/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.cvsrep.CRU478Test;
import com.cenqua.fisheye.cvsrep.RcsFileHistory;
import com.cenqua.fisheye.cvsrep.RcsRevisionInfo;
import junit.framework.TestCase;

public class CRU622Test
extends TestCase {
    public void testRevisionFromString() throws Exception {
        this.subtestBranches("test/testfiles/CRU622/bccdc.mk,v", new String[][]{{"1.1", "MAIN"}, {"1.2.1.1", "d420cpe"}, {"1.2.2.1", "juil"}, {"1.1.0.1", "d410cpe"}, {"1.1.1.1", "cgen"}, {"1.1.0.1.1.1", "d410cpe-dreba"}, {"1.2.1.1.1.1", "m420cpe"}, {"1.2.1.1.2.1", "d420cpe-mac"}, {"1.2.1.1.3.1", "mts"}, {"1.2.1.1.3.1.1.1", "s421p1lx"}});
    }

    private void subtestBranches(String file, String[][] expectedBranchMap) throws Exception {
        RcsFileHistory h = CRU478Test.parseFile(file);
        for (String[] pair : expectedBranchMap) {
            String rev = pair[0];
            String br = pair[1];
            RcsRevisionInfo ri = h.getRevision(rev);
            CRU622Test.assertNotNull((String)rev, (Object)ri);
            CRU622Test.assertEquals((String)br, (String)ri.getBranch());
            CRU622Test.assertEquals((String)rev, (String)h.getFirstRevisionOnBranch(br));
        }
    }
}

