/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.CvsScmConfig;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.cvsrep.RcsFileHistory;
import com.cenqua.fisheye.cvsrep.RcsFileHistoryFactory;
import com.cenqua.fisheye.cvsrep.Revision;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import junit.framework.TestCase;

public class CRU478Test
extends TestCase {
    public void testRevisionFromString() throws Exception {
        RcsFileHistory h = CRU478Test.parseFile("test/testfiles/CRU478/a.txt,v");
        CRU478Test.assertEquals((Object)new Revision("1.2"), (Object)h.revisionFromString("BRANCH_1$BP"));
        CRU478Test.assertEquals((Object)new Revision("1.2.2.1"), (Object)h.revisionFromString("BRANCH_1"));
        CRU478Test.assertEquals((Object)new Revision("1.2"), (Object)h.revisionFromString("BRANCH_2$BP"));
        CRU478Test.assertEquals((Object)new Revision("1.2"), (Object)h.revisionFromString("BRANCH_2"));
    }

    public static RcsFileHistory parseFile(String fname) throws IOException, RCSParser.ParseException {
        File f = new File(FisheyeTestEnv.WORKSPACE_DIR, fname);
        BufferedRandomAccessInputStream in = new BufferedRandomAccessInputStream(f);
        RcsFileHistoryFactory.Result history = RcsFileHistoryFactory.createHistory((BufferedRandomAccessInputStream)in, (Charset)CvsScmConfig.DEFAULT_CVS_ENCODING, (Path)new Path((CharSequence)f.getName()));
        in.close();
        return history.getHistory();
    }
}

