/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.CvsScmConfig;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.cvsrep.RcsFileHistory;
import com.cenqua.fisheye.cvsrep.RcsFileHistoryFactory;
import com.cenqua.fisheye.cvsrep.Revision;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import junit.framework.TestCase;

public class CRU473Test
extends TestCase {
    public void testParsing() throws Exception {
        RcsFileHistory h = this.parseFile("test/testfiles/CRU473/DOSWOCR.C,v");
        CRU473Test.assertEquals((Object)new Revision("1.3"), (Object)h.revisionFromString("083100"));
        h = this.parseFile("test/testfiles/CRU473/GETSWOCR.C,v");
        CRU473Test.assertEquals((Object)new Revision("1.4"), (Object)h.revisionFromString("083100"));
        h = this.parseFile("test/testfiles/CRU473/VERB1.DCL,v");
        CRU473Test.assertEquals((Object)new Revision("1.18"), (Object)h.revisionFromString("083100"));
        h = this.parseFile("test/testfiles/CRU473/VERBTBL.C,v");
        CRU473Test.assertEquals((Object)new Revision("1.25"), (Object)h.revisionFromString("083100"));
    }

    private RcsFileHistory parseFile(String fname) throws IOException, RCSParser.ParseException {
        File f = new File(FisheyeTestEnv.WORKSPACE_DIR, fname);
        BufferedRandomAccessInputStream in = new BufferedRandomAccessInputStream(f);
        RcsFileHistoryFactory.Result history = RcsFileHistoryFactory.createHistory((BufferedRandomAccessInputStream)in, (Charset)CvsScmConfig.DEFAULT_CVS_ENCODING, (Path)new Path((CharSequence)f.getName()));
        in.close();
        return history.getHistory();
    }
}

