/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.CvsScmConfig;
import com.cenqua.fisheye.cvsrep.RcsFileHistory;
import com.cenqua.fisheye.cvsrep.RcsFileHistoryFactory;
import com.cenqua.fisheye.cvsrep.Revision;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import junit.framework.TestCase;

public class CRU430Test
extends TestCase {
    private File testfile;
    private RcsFileHistoryFactory.Result history;

    private void loadFile(String fname) throws Exception {
        this.testfile = new File(FisheyeTestEnv.WORKSPACE_DIR, fname);
        BufferedRandomAccessInputStream in = new BufferedRandomAccessInputStream(this.testfile);
        this.history = RcsFileHistoryFactory.createHistory((BufferedRandomAccessInputStream)in, (Charset)CvsScmConfig.DEFAULT_CVS_ENCODING, (Path)new Path((CharSequence)this.testfile.getName()));
        in.close();
    }

    public void testSyntheticBranchpointTags() throws Exception {
        this.loadFile("test/testfiles/CRU430/readme,v");
        RcsFileHistory h = this.history.getHistory();
        Map sm = h.getSymbolMap();
        CRU430Test.assertEquals((Object)new Revision("1.1"), sm.get("yoyo$BP"));
        CRU430Test.assertEquals((Object)new Revision("1.3"), sm.get("BRANCH1$BP"));
        CRU430Test.assertEquals((Object)new Revision("1.2"), sm.get("EMPTY_BRANCH1$BP"));
        CRU430Test.assertTrue((boolean)h.getRevision("1.1").getTags().contains("yoyo$BP"));
        CRU430Test.assertTrue((boolean)h.getRevision("1.3").getTags().contains("BRANCH1$BP"));
        CRU430Test.assertTrue((boolean)h.getRevision("1.2").getTags().contains("EMPTY_BRANCH1$BP"));
    }
}

