/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.CvsScmConfig;
import com.cenqua.fisheye.cvsrep.RcsFileHistory;
import com.cenqua.fisheye.cvsrep.RcsFileHistoryFactory;
import com.cenqua.fisheye.cvsrep.Revision;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;

public class CRU414Test
extends TestCase {
    public void testLimeshopFile() throws Exception {
        String fname = "test/testfiles/CRU414/HTML.java,v";
        File f = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/CRU414/HTML.java,v");
        BufferedRandomAccessInputStream in = new BufferedRandomAccessInputStream(f);
        RcsFileHistoryFactory.Result history = RcsFileHistoryFactory.createHistory((BufferedRandomAccessInputStream)in, (Charset)CvsScmConfig.DEFAULT_CVS_ENCODING, (Path)new Path((CharSequence)f.getName()));
        in.close();
        RcsFileHistory h = history.getHistory();
        Collection branches = h.getBranches();
        CRU414Test.assertEquals((int)2, (int)branches.size());
        CRU414Test.assertTrue((boolean)branches.contains("MAIN"));
        CRU414Test.assertTrue((boolean)branches.contains("1"));
        List revs = h.getRevisions("MAIN");
        CRU414Test.assertEquals((int)1, (int)revs.size());
        CRU414Test.assertTrue((boolean)revs.contains("1.1.1.1"));
        revs = h.getRevisions("1");
        CRU414Test.assertEquals((int)2, (int)revs.size());
        CRU414Test.assertTrue((boolean)revs.contains("1.1"));
        CRU414Test.assertTrue((boolean)revs.contains("1.2"));
        CRU414Test.assertEquals((Object)new Revision("1.1.1.1"), (Object)h.revisionFromString("HEAD"));
        CRU414Test.assertEquals((Object)new Revision("1.1.1.1"), (Object)h.revisionFromString("MAIN"));
        CRU414Test.assertEquals((Object)new Revision("1.2"), (Object)h.revisionFromString("1"));
    }
}

