/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.CvsScmConfig;
import com.cenqua.fisheye.cvsrep.RcsFileHistory;
import com.cenqua.fisheye.cvsrep.RcsFileHistoryFactory;
import com.cenqua.fisheye.cvsrep.RcsRevisionInfo;
import com.cenqua.fisheye.cvsrep.Revision;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;

public class CRU405Test
extends TestCase {
    private File testfile;
    private RcsFileHistoryFactory.Result history;

    private void loadFile(String fname) throws Exception {
        this.testfile = new File(FisheyeTestEnv.WORKSPACE_DIR, fname);
        BufferedRandomAccessInputStream in = new BufferedRandomAccessInputStream(this.testfile);
        this.history = RcsFileHistoryFactory.createHistory((BufferedRandomAccessInputStream)in, (Charset)CvsScmConfig.DEFAULT_CVS_ENCODING, (Path)new Path((CharSequence)this.testfile.getName()));
        in.close();
    }

    public void testLineCounts() throws Exception {
        this.loadFile("test/testfiles/CRU405/SourceViewServlet.java,v");
        RcsFileHistory h = this.history.getHistory();
        CRU405Test.assertEquals((int)102, (int)h.getRevision("1.1").getLineCount());
        CRU405Test.assertEquals((int)125, (int)h.getRevision("1.2").getLineCount());
        CRU405Test.assertEquals((int)130, (int)h.getRevision("1.3").getLineCount());
        CRU405Test.assertEquals((int)130, (int)h.getRevision("2.0").getLineCount());
        CRU405Test.assertEquals((int)137, (int)h.getRevision("2.1").getLineCount());
        CRU405Test.assertEquals((int)141, (int)h.getRevision("2.2").getLineCount());
        CRU405Test.assertEquals((int)102, (int)h.getRevision("1.1.1.1").getLineCount());
    }

    public void testBranches1() throws Exception {
        this.loadFile("test/testfiles/CRU405/SourceViewServlet.java,v");
        RcsFileHistory h = this.history.getHistory();
        CRU405Test.assertEquals((String)"2.2", (String)h.getHead());
        CRU405Test.assertEquals((String)"1.1", (String)h.getFirstRevisionOnBranch("MAIN"));
        this.assertAdjacentInBranch("1.1", "1.2");
        this.assertAdjacentInBranch("1.2", "1.3");
        this.assertAdjacentInBranch("1.3", "2.0");
        this.assertAdjacentInBranch("2.0", "2.1");
        this.assertAdjacentInBranch("2.1", "2.2");
        this.assertIsAncestor("1.1", "1.1.1.1");
    }

    public void testBranches2() throws Exception {
        this.loadFile("test/testfiles/CRU405/readme,v");
        RcsFileHistory h = this.history.getHistory();
        Collection branches = h.getBranches();
        CRU405Test.assertEquals((int)3, (int)branches.size());
        System.out.println(branches);
        CRU405Test.assertTrue((boolean)branches.contains("MAIN"));
        CRU405Test.assertTrue((boolean)branches.contains("BRANCH1"));
        CRU405Test.assertTrue((boolean)branches.contains("yoyo"));
        CRU405Test.assertEquals(null, (Object)h.getCvsBranchPoint("MAIN"));
        CRU405Test.assertEquals((Object)new Revision("1.1"), (Object)h.getCvsBranchPoint("yoyo"));
        CRU405Test.assertEquals((Object)new Revision("1.3"), (Object)h.getCvsBranchPoint("BRANCH1"));
        CRU405Test.assertEquals((String)"1.3", (String)h.getHead());
        CRU405Test.assertEquals((String)"1.1", (String)h.getFirstRevisionOnBranch("MAIN"));
        CRU405Test.assertEquals((String)"1.1.1.1", (String)h.getFirstRevisionOnBranch("yoyo"));
        CRU405Test.assertEquals((String)"1.3.2.1", (String)h.getFirstRevisionOnBranch("BRANCH1"));
        this.assertAdjacentInBranch("1.1", "1.2");
        this.assertAdjacentInBranch("1.2", "1.3");
        this.assertIsAncestor("1.1", "1.1.1.1");
        this.assertIsAncestor("1.3", "1.3.2.1");
        List revs = h.getRevisions("BRANCH1");
        CRU405Test.assertEquals((int)1, (int)revs.size());
        CRU405Test.assertEquals((String)"1.3.2.1", (String)((String)revs.get(0)));
        CRU405Test.assertEquals((int)1, (int)h.getRevision("1.1").getBranches().size());
        CRU405Test.assertEquals((int)0, (int)h.getRevision("1.2").getBranches().size());
        CRU405Test.assertEquals((int)1, (int)h.getRevision("1.3").getBranches().size());
        CRU405Test.assertEquals((int)0, (int)h.getRevision("1.1.1.1").getBranches().size());
        CRU405Test.assertEquals((int)0, (int)h.getRevision("1.3.2.1").getBranches().size());
    }

    private void assertAdjacentInBranch(String a, String b) {
        RcsRevisionInfo i1 = this.history.getHistory().getCvsRevision(a);
        CRU405Test.assertNotNull((Object)i1);
        RcsRevisionInfo i2 = this.history.getHistory().getCvsRevision(b);
        CRU405Test.assertNotNull((Object)i2);
        CRU405Test.assertEquals((String)i1.getNextInBranch().getRevision(), (String)b);
        CRU405Test.assertEquals((String)i2.getAncestor().getRevision(), (String)a);
    }

    private void assertIsAncestor(String a, String b) {
        RcsRevisionInfo i1 = this.history.getHistory().getCvsRevision(a);
        CRU405Test.assertNotNull((Object)i1);
        RcsRevisionInfo i2 = this.history.getHistory().getCvsRevision(b);
        CRU405Test.assertNotNull((Object)i2);
        CRU405Test.assertEquals((String)i2.getAncestor().getRevision(), (String)a);
    }
}

