/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.Annotator;
import com.cenqua.fisheye.cvsrep.CvsScmConfig;
import com.cenqua.fisheye.cvsrep.CvsTestUtil;
import com.cenqua.fisheye.cvsrep.RcsFileHistoryFactory;
import com.cenqua.fisheye.cvsrep.RcsRevisionInfo;
import com.cenqua.fisheye.cvsrep.Revision;
import com.cenqua.fisheye.cvsrep.cache.CvsCache;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import junit.framework.TestCase;

public class CRU345Test
extends TestCase {
    public void testLimeshopFile() throws Exception {
        File f = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/CRU345/limeshop.html,v");
        File r = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/CRU345/");
        CvsCache rep = CvsTestUtil.makeRevisionCache(r);
        BufferedRandomAccessInputStream in = new BufferedRandomAccessInputStream(f);
        RcsFileHistoryFactory.Result history = RcsFileHistoryFactory.createHistory((BufferedRandomAccessInputStream)in, (Charset)CvsScmConfig.DEFAULT_CVS_ENCODING, (Path)new Path((CharSequence)f.getName()));
        in.close();
        this.assertLineCounts(0, 0, 0, 0, history.getHistory().getCvsRevision("1.1"));
        this.assertLineCounts(806, 806, 806, 0, history.getHistory().getCvsRevision("1.2"));
        this.assertLineCounts(699, -107, 645, 752, history.getHistory().getCvsRevision("1.3"));
        this.assertLineCounts(699, 0, 2, 2, history.getHistory().getCvsRevision("1.4"));
        this.assertLineCounts(699, 0, 36, 36, history.getHistory().getCvsRevision("1.5"));
        this.assertLineCounts(0, -699, 0, 699, history.getHistory().getCvsRevision("1.6"));
        this.assertLineCounts(806, 806, 806, 0, history.getHistory().getCvsRevision("1.1.2.1"));
        Annotator ann = new Annotator(rep.getFileHistory(new Path((CharSequence)"limeshop.html")), history.getTree());
        ann.annotate(new Revision("1.5"));
        List chunks = ann.getChunks();
        CRU345Test.assertEquals((int)45, (int)chunks.size());
        int i = 0;
        this.assertChunkValue("1.2", 1, 16, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.3", 17, 18, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.2", 19, 20, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.3", 21, 32, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.2", 33, 35, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.3", 36, 37, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.2", 38, 38, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.3", 39, 39, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.4", 40, 40, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.3", 41, 61, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.4", 62, 62, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.3", 63, 123, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.2", 124, 125, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.3", 126, 126, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.2", 127, 127, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.3", 128, 129, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.2", 130, 130, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.3", 131, 231, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.2", 232, 233, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.3", 234, 234, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.2", 235, 235, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.3", 236, 237, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.2", 238, 238, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.3", 239, 302, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.5", 303, 338, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.3", 339, 447, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.2", 448, 449, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.3", 450, 450, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.2", 451, 451, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.3", 452, 453, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.2", 454, 454, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.3", 455, 571, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.2", 572, 573, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.3", 574, 574, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.2", 575, 575, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.3", 576, 577, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.2", 578, 578, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.3", 579, 682, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.2", 683, 684, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.3", 685, 685, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.2", 686, 686, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.3", 687, 687, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.2", 688, 689, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.3", 690, 692, (BlameChunk)chunks.get(i++));
        this.assertChunkValue("1.2", 693, 699, (BlameChunk)chunks.get(i++));
    }

    private void assertLineCounts(int count, int change, int added, int removed, RcsRevisionInfo info) {
        CRU345Test.assertEquals((int)count, (int)info.getLineCount());
        CRU345Test.assertEquals((int)change, (int)(info.getLinesAdded() - info.getLinesRemoved()));
        CRU345Test.assertEquals((int)added, (int)info.getLinesAdded());
        CRU345Test.assertEquals((int)removed, (int)info.getLinesRemoved());
    }

    private void assertChunkValue(String ver, int start, int last, BlameChunk chunk) {
        CRU345Test.assertEquals((String)ver, (String)chunk.getRevision());
        CRU345Test.assertEquals((int)(--start), (int)chunk.getStart());
        CRU345Test.assertEquals((int)(--last - start + 1), (int)chunk.getLength());
    }
}

