/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.cvsrep;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.AllowRules;
import com.cenqua.fisheye.cvsrep.CvsRepository;
import com.cenqua.fisheye.cvsrep.RcsFileHistory;
import com.cenqua.fisheye.cvsrep.RcsRevisionInfo;
import com.cenqua.fisheye.cvsrep.Revision;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.io.Utf16ERandomAccessIoStream;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import junit.framework.TestCase;

public class CRU340Test
extends TestCase {
    private static final File TESTDIR = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/CRU340");
    private static final Charset EUC_KR = Charset.forName("EUC-KR");
    private static final String COMMENT_1_25 = new String(new char[]{'\uac1c', '\uc120', '\uc0ac', '\ud56d', ' ', '\ucd94', '\uac00', '\n'});
    private CvsRepository mRep;

    protected void setUp() throws Exception {
        this.mRep = new CvsRepository("test", new AllowRules(new ArrayList(), new ArrayList()), TESTDIR, EUC_KR);
    }

    public void test_EUC_KR() throws Exception {
        RcsFileHistory h = this.mRep.getFileHistoryInfo(new Path((CharSequence)"Buil_List.txt"));
        RcsRevisionInfo rev = h.getRevision("1.25");
        CRU340Test.assertEquals((String)COMMENT_1_25, (String)rev.getComment());
        this.subtestContents(h, "1.1");
    }

    private void subtestContents(RcsFileHistory h, String revstr) throws Exception {
        File tmpfile = FisheyeTestUtil.createTempFile("tmp");
        RcsRevisionInfo ri = h.getRevision(revstr);
        OutputStream out = new BufferedOutputStream(new FileOutputStream(tmpfile));
        this.mRep.getBinaryRevision(h.getPath(), new Revision(revstr), out);
        out.close();
        FisheyeTestUtil.assertByteIdentical(new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/CRU340/Buil_List_" + revstr + "_raw.txt"), tmpfile);
        out = new FileOutputStream(tmpfile);
        this.mRep.getTextRevision(ri.getPath(), ri.getCvsRevision(), ri.makeKeywordExpansionInfo(), out, null);
        out.close();
        FisheyeTestUtil.assertByteIdentical(new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/CRU340/Buil_List_" + revstr + "_raw.txt"), tmpfile);
        File tmpfile2 = FisheyeTestUtil.createTempFile("tmp2");
        IOHelper.translateEncodings((File)tmpfile, (Charset)EUC_KR, (File)tmpfile2, (Charset)Utf16ERandomAccessIoStream.UTF_16LE);
        FisheyeTestUtil.assertCharIdentical(new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/CRU340/Buil_List_" + revstr + "_utf8.txt"), Charset.forName("UTF-8"), tmpfile2, Charset.forName("UTF-16LE"));
    }
}

