/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.atlassian.fecru.util.CaptureLog4jLogsRule;
import com.cenqua.fisheye.ctl.Run;
import org.apache.log4j.Level;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.RestoreSystemProperties;
import org.junit.rules.TestRule;

public class RunTest {
    @Rule
    public CaptureLog4jLogsRule logs = new CaptureLog4jLogsRule();
    @Rule
    public TestRule restoreSystemProperties = new RestoreSystemProperties();

    @Test
    public void testWarnOnUnsupportedJavaVersion_shouldWarnOnUnsupported() throws Exception {
        System.setProperty("java.version", "1.9");
        Run.warnOnUnsupportedJavaVersion();
        Assert.assertThat(this.logs.getEvents(), (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)new CaptureLog4jLogsRule.LogWithLevel(Level.WARN), (Matcher)new CaptureLog4jLogsRule.LogWithMessage("Unsupported java version detected: 1.9"))));
    }

    @Test
    public void testWarnOnUnsupportedJavaVersion_shouldNotWarnOnSupported() throws Exception {
        System.setProperty("java.version", "1.8");
        Run.warnOnUnsupportedJavaVersion();
        Assert.assertThat(this.logs.getEvents(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher[])new Matcher[]{new CaptureLog4jLogsRule.LogWithLevel(Level.WARN)}))));
    }
}

