/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.atlassian.fecru.test.FecruJUnit4ClassRunner;
import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBControlFactoryImpl;
import com.cenqua.fisheye.FishEyeCtl;
import com.cenqua.fisheye.ctl.AutoCloseableSupplierTestRule;
import com.cenqua.fisheye.ctl.DBControlConnectionSupplier;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.ExpectedSystemExit;
import org.junit.runner.RunWith;

@RunWith(value=FecruJUnit4ClassRunner.class)
public final class RestoreTest {
    @Rule
    public final ExpectedSystemExit exitRule = ExpectedSystemExit.none();
    @Rule
    public AutoCloseableSupplierTestRule<Connection, DBControlConnectionSupplier> connectionSupplier;

    @Before
    public void setUp() throws Exception {
        System.setProperty("fisheye.home", new File("/Users/kcichy/src/fecru_d", "output/dist").getAbsolutePath());
        System.setProperty("fisheye.inst", new File("/Users/kcichy/src/fecru_d", "output/restore_dist_inst").getAbsolutePath());
        this.connectionSupplier = new AutoCloseableSupplierTestRule(new DBControlConnectionSupplier(() -> new DBControlFactoryImpl().getCurrentControl()));
    }

    @Test
    public void testHsqldb() throws Exception {
        this.exitRule.expectSystemExitWithStatus(0);
        this.exitRule.checkAssertionAfterwards(() -> Assert.assertThat((String)"AO_B434B9_WEB_HOOK rows", (Object)this.getSqlResultCount("SELECT * FROM AO_B434B9_WEB_HOOK"), (Matcher)Matchers.is((Object)1)));
        FishEyeCtl.main(new String[]{"restore", "--force", "-f", "/Users/kcichy/src/fecru_d/test/backup/backup.zip"});
    }

    private int getSqlResultCount(String sql) throws CruDBException, SQLException {
        System.out.println("Execute " + sql);
        try (Connection con = this.connectionSupplier.get();){
            ResultSet rs = con.createStatement().executeQuery(sql);
            ResultSetMetaData metaData = rs.getMetaData();
            System.out.println("Result columns: " + this.getColumnNames(metaData));
            int count = 0;
            while (rs.next()) {
                System.out.println("" + count + ": " + this.getRowValues(rs, metaData.getColumnCount()));
                ++count;
            }
            System.out.println("Total result: " + count);
            int n = count;
            return n;
        }
    }

    private Iterable<Object> getRowValues(ResultSet rs, int columnCount) throws SQLException {
        ArrayList<Object> builder = new ArrayList<Object>();
        for (int i = 1; i <= columnCount; ++i) {
            builder.add(rs.getObject(i));
        }
        return builder;
    }

    private Iterable<String> getColumnNames(ResultSetMetaData metaData) throws SQLException {
        ArrayList<String> builder = new ArrayList<String>();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            builder.add(metaData.getColumnName(i));
        }
        return builder;
    }
}

