/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.atlassian.crucible.migration.PrintStreamProgressMonitor;
import com.atlassian.crucible.migration.ProgressMonitor;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.DatabaseType;
import com.cenqua.fisheye.config1.DriverSource;
import com.cenqua.fisheye.ctl.RestoreConfig;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import de.schlichtherle.util.zip.ZipFile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class RestoreConfigTest {
    private static final String EMPTY_CONFIG_XML = "<config control-bind=\"127.0.0.1:8059\" version=\"1.0\">\n</config>\n";
    private static final String FILLED_CONFIG_XML = "<config control-bind=\"127.0.0.1:8059\" version=\"1.0\">\n<database type=\"postgresql\">\n        <connection driver=\"org.postgresql.OtherDriver\" jdbcurl=\"jdbc:postgresql://localhost:5432/fisheye\" username=\"fish\" password=\"fishu\" driverSource=\"bundled\"/>\n    </database>\n</config>\n";
    private ProgressMonitor monitor = new PrintStreamProgressMonitor(System.out);
    private List<de.schlichtherle.io.File> files = Lists.newArrayList();

    private ZipFile makeBackupZip(String configXml) throws IOException {
        de.schlichtherle.io.File file = new de.schlichtherle.io.File(Files.createTempDir(), "backup.zip");
        de.schlichtherle.io.File configDir = new de.schlichtherle.io.File((File)file, "config");
        configDir.mkdir();
        de.schlichtherle.io.File configFile = new de.schlichtherle.io.File((File)configDir, "config.xml");
        try (ByteArrayInputStream is = new ByteArrayInputStream(configXml.getBytes("UTF-8"));){
            configFile.catFrom((InputStream)is);
        }
        de.schlichtherle.io.File.umount();
        this.files.add(file);
        return new ZipFile((File)file);
    }

    @Test
    public void testGetConfigFromBackup_noOverride_emptyConfig() throws Exception {
        ZipFile emptyConfigZip = this.makeBackupZip(EMPTY_CONFIG_XML);
        RestoreConfig restoreConfig = new RestoreConfig(emptyConfigZip, Collections.emptyMap(), this.monitor);
        ConfigDocument configFromBackup = restoreConfig.getConfigFromBackup();
        boolean isOverride = restoreConfig.isDbConfigOverriden();
        Assert.assertThat((Object)isOverride, (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)configFromBackup.getConfig().isSetDatabase(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testGetConfigFromBackup_noOverride_filledConfig() throws Exception {
        ZipFile filledConfigZip = this.makeBackupZip(FILLED_CONFIG_XML);
        RestoreConfig restoreConfig = new RestoreConfig(filledConfigZip, Collections.emptyMap(), this.monitor);
        ConfigDocument configFromBackup = restoreConfig.getConfigFromBackup();
        boolean isOverride = restoreConfig.isDbConfigOverriden();
        Assert.assertThat((Object)isOverride, (Matcher)Matchers.is((Object)false));
        this.assertConfig(configFromBackup, DatabaseType.Type.POSTGRESQL, "org.postgresql.OtherDriver", "jdbc:postgresql://localhost:5432/fisheye", "fish", "fishu", DriverSource.BUNDLED);
    }

    @Test
    public void testGetConfigFromBackup_overrideCredentials_filledConfig() throws Exception {
        ZipFile filledConfigZip = this.makeBackupZip(FILLED_CONFIG_XML);
        ImmutableMap properties = ImmutableMap.of((Object)"sql.username", (Object)"test", (Object)"sql.password", (Object)"pass");
        RestoreConfig restoreConfig = new RestoreConfig(filledConfigZip, (Map)properties, this.monitor);
        ConfigDocument configFromBackup = restoreConfig.getConfigFromBackup();
        boolean isOverride = restoreConfig.isDbConfigOverriden();
        Assert.assertThat((Object)isOverride, (Matcher)Matchers.is((Object)true));
        this.assertConfig(configFromBackup, DatabaseType.Type.POSTGRESQL, "org.postgresql.OtherDriver", "jdbc:postgresql://localhost:5432/fisheye", "test", "pass", DriverSource.BUNDLED);
    }

    @Test
    public void testGetConfigFromBackup_overrideDbTypeWithHsql_filledConfig() throws Exception {
        ZipFile filledConfigZip = this.makeBackupZip(FILLED_CONFIG_XML);
        ImmutableMap properties = ImmutableMap.of((Object)"sql.dbtype", (Object)DBType.HSQL.getConfigEnumName());
        RestoreConfig restoreConfig = new RestoreConfig(filledConfigZip, (Map)properties, this.monitor);
        ConfigDocument configFromBackup = restoreConfig.getConfigFromBackup();
        boolean isOverride = restoreConfig.isDbConfigOverriden();
        Assert.assertThat((Object)isOverride, (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)configFromBackup.getConfig().isSetDatabase(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testGetConfigFromBackup_overrideDbTypeWithOracle_filledConfig() throws Exception {
        ZipFile filledConfigZip = this.makeBackupZip(FILLED_CONFIG_XML);
        ImmutableMap properties = ImmutableMap.builder().put((Object)"sql.dbtype", (Object)DBType.ORACLE.getConfigEnumName()).put((Object)"sql.username", (Object)"test").put((Object)"sql.password", (Object)"pass").put((Object)"sql.jdbcurl", (Object)"jdbc:oracle:thin:@localhost:1521:db").put((Object)"sql.driversource", (Object)"user").put((Object)"sql.driver", (Object)"oracle.jdbc.EnterpriseOracleDriver").build();
        RestoreConfig restoreConfig = new RestoreConfig(filledConfigZip, (Map)properties, this.monitor);
        ConfigDocument configFromBackup = restoreConfig.getConfigFromBackup();
        boolean isOverride = restoreConfig.isDbConfigOverriden();
        Assert.assertThat((Object)isOverride, (Matcher)Matchers.is((Object)true));
        this.assertConfig(configFromBackup, DatabaseType.Type.ORACLE, (String)properties.get("sql.driver"), (String)properties.get("sql.jdbcurl"), "test", "pass", DriverSource.USER);
    }

    @Test
    public void testGetConfigFromBackup_overrideDbTypeWithPsqlWithDefaults_emptyConfig() throws Exception {
        ZipFile emptyConfigZip = this.makeBackupZip(EMPTY_CONFIG_XML);
        ImmutableMap properties = ImmutableMap.builder().put((Object)"sql.dbtype", (Object)DBType.POSTGRESQL.getConfigEnumName()).put((Object)"sql.username", (Object)"test").put((Object)"sql.password", (Object)"pass").put((Object)"sql.jdbcurl", (Object)"jdbc:postgresql://localhost:5432/crucible_new").build();
        RestoreConfig restoreConfig = new RestoreConfig(emptyConfigZip, (Map)properties, this.monitor);
        ConfigDocument configFromBackup = restoreConfig.getConfigFromBackup();
        boolean isOverride = restoreConfig.isDbConfigOverriden();
        Assert.assertThat((Object)isOverride, (Matcher)Matchers.is((Object)true));
        this.assertConfig(configFromBackup, DatabaseType.Type.POSTGRESQL, DBType.POSTGRESQL.getDriver(), (String)properties.get("sql.jdbcurl"), "test", "pass", DriverSource.BUNDLED);
    }

    @After
    public void tearDown() throws Exception {
        for (de.schlichtherle.io.File file : this.files) {
            file.deleteAll();
            file.delete();
        }
    }

    private void assertConfig(ConfigDocument configFromBackup, DatabaseType.Type.Enum dbType, String driver, String url, String user, String password, DriverSource.Enum driverSource) {
        Assert.assertThat((Object)configFromBackup.getConfig().getDatabase().getType(), (Matcher)Matchers.equalTo((Object)dbType));
        Assert.assertThat((Object)configFromBackup.getConfig().getDatabase().getConnection().getDriver(), (Matcher)Matchers.equalTo((Object)driver));
        Assert.assertThat((Object)configFromBackup.getConfig().getDatabase().getConnection().getJdbcurl(), (Matcher)Matchers.equalTo((Object)url));
        Assert.assertThat((Object)configFromBackup.getConfig().getDatabase().getConnection().getUsername(), (Matcher)Matchers.equalTo((Object)user));
        Assert.assertThat((Object)configFromBackup.getConfig().getDatabase().getConnection().getPassword(), (Matcher)Matchers.equalTo((Object)password));
        Assert.assertThat((Object)configFromBackup.getConfig().getDatabase().getConnection().getDriverSource(), (Matcher)Matchers.equalTo((Object)driverSource));
    }
}

