/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.ctl.VerifySvnSymbolicRules;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PathAggregatorTest {
    VerifySvnSymbolicRules.PathAggregator pa;

    @Before
    public void setUp() {
        this.pa = new VerifySvnSymbolicRules.PathAggregator(3){
            {
                this.addPath("/dir/subdir");
                this.addPath("/dir/subdir");
                this.addPath("/dir/subdir/file2.txt");
                this.addPath("/dir/anotherdir/file.txt");
                this.addPath("/dir1/dir2/dir3/dir4a/fileA.txt");
                this.addPath("/dir1/dir2/dir3/dir4b/fileB.txt");
            }

            void addPath(String path) {
                Path p = new Path((CharSequence)path).simplify();
                this.addPath(p);
            }
        };
    }

    @Test
    public void testReportTopPaths1() {
        Collection topPaths = this.pa.getTopPaths(1);
        Assert.assertThat((Object)topPaths, (Matcher)Matchers.hasSize((int)1));
        VerifySvnSymbolicRules.PathOccurrences topPath = (VerifySvnSymbolicRules.PathOccurrences)Iterables.getOnlyElement((Iterable)topPaths);
        Assert.assertThat((Object)topPath, (Matcher)Matchers.equalTo((Object)this.makePathOccurences("/dir", 4)));
    }

    @Test
    public void testReportTopPaths4() {
        Collection topPaths = this.pa.getTopPaths(4);
        Assert.assertThat((Object)topPaths, (Matcher)Matchers.hasSize((int)4));
        Iterator iter = topPaths.iterator();
        Assert.assertThat(iter.next(), (Matcher)Matchers.equalTo((Object)this.makePathOccurences("/dir", 4)));
        Assert.assertThat(iter.next(), (Matcher)Matchers.equalTo((Object)this.makePathOccurences("/dir/subdir", 3)));
        Assert.assertThat(iter.next(), (Matcher)Matchers.equalTo((Object)this.makePathOccurences("/dir1/dir2/dir3", 2)));
        Assert.assertThat(iter.next(), (Matcher)Matchers.equalTo((Object)this.makePathOccurences("/dir/anotherdir/file.txt", 1)));
    }

    @Test
    public void testGetPathsAddedCount() {
        Assert.assertThat((Object)this.pa.getPathsAddedCount(), (Matcher)Matchers.is((Object)6));
    }

    @Test
    public void testPathOccurencesHigherCountWins() {
        VerifySvnSymbolicRules.PathOccurrences po1 = this.makePathOccurences("a", 4);
        VerifySvnSymbolicRules.PathOccurrences po2 = this.makePathOccurences("abc", 3);
        VerifySvnSymbolicRules.PathOccurrences po3 = this.makePathOccurences("abc/def", 3);
        VerifySvnSymbolicRules.PathOccurrences po4 = this.makePathOccurences("abc/ddd", 3);
        Assert.assertThat((String)"higher count wins", (Object)po1.compareTo(po2), (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((String)"higher count wins 2", (Object)po1.compareTo(po3), (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((String)"longer path wins", (Object)po2.compareTo(po3), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((String)"equal elements are equal", (Object)po2.compareTo(po2), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((String)"same count and same path length - alphabetic order used", (Object)po4.compareTo(po3), (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0))));
    }

    private VerifySvnSymbolicRules.PathOccurrences makePathOccurences(String path, int count) {
        return new VerifySvnSymbolicRules.PathOccurrences(new Path((CharSequence)path), count);
    }
}

