/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.ctl.NativeLibrarySetup;
import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;

public class NativeLibrarySetupTest
extends TestCase {
    File basedir;

    protected void setUp() throws Exception {
        this.basedir = FisheyeTestUtil.createTempDir("nativetest");
        this.makeSubdir("linux-i386");
        this.makeSubdir("osx-ppc");
        this.makeSubdir("solaris-sparc");
        this.makeSubdir("win32-x86");
    }

    private void makeSubdir(String name) throws IOException {
        File d = new File(this.basedir, name);
        if (!d.mkdirs()) {
            throw new IOException("could not create " + d);
        }
    }

    public void test_linux_i386() throws Exception {
        this.assertDirFound("linux-i386", "linux", "i386");
        this.assertDirFound("linux-i386", "linux", "x86");
        this.assertDirFound("linux-i386", "linux", "i486");
        this.assertDirFound("linux-i386", "linux", "i586");
        this.assertDirFound("linux-i386", "linux", "i686");
        this.assertDirNotFound("linux", "foo");
    }

    public void test_osx_ppc() throws Exception {
        this.assertDirFound("osx-ppc", "mac os x", "ppc");
    }

    public void test_win32_x86() throws Exception {
        this.assertDirFound("win32-x86", "windows 95", "x86");
        this.assertDirFound("win32-x86", "windows 98", "x86");
        this.assertDirFound("win32-x86", "windows me", "x86");
        this.assertDirFound("win32-x86", "windows nt", "x86");
        this.assertDirFound("win32-x86", "windows 2000", "x86");
        this.assertDirFound("win32-x86", "windows xp", "x86");
        this.assertDirFound("win32-x86", "windows 2003", "x86");
        this.assertDirFound("win32-x86", "windows ce", "x86");
    }

    public void test_solaris_sparc() throws Exception {
        this.assertDirFound("solaris-sparc", "solaris", "sparc");
        this.assertDirFound("solaris-sparc", "sunos", "sparc");
    }

    private void assertDirNotFound(String os, String arch) {
        File d = NativeLibrarySetup.findNativeDir((File)this.basedir, (String)os, (String)arch);
        NativeLibrarySetupTest.assertNull((Object)d);
    }

    private void assertDirFound(String dirname, String os, String arch) {
        File d = NativeLibrarySetup.findNativeDir((File)this.basedir, (String)os, (String)arch);
        NativeLibrarySetupTest.assertNotNull((Object)d);
        NativeLibrarySetupTest.assertEquals((String)dirname, (String)d.getName());
    }
}

