/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.cenqua.fisheye.ctl.CheckClassLoader;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class CheckClassLoaderTest {
    private CheckClassLoader checkClass;
    @Mock
    Logger log;

    @Before
    public void setUp() throws Exception {
        this.checkClass = new CheckClassLoader((Category)this.log);
    }

    @Test
    public void testUsageAndErrorIfNoArguments() throws Exception {
        this.checkClass.mainImpl(new String[0]);
        ((Logger)Mockito.verify((Object)this.log)).error(Matchers.argThat((Matcher)org.hamcrest.Matchers.containsString((String)"Usage:")));
        ((Logger)Mockito.verify((Object)this.log)).error(Matchers.argThat((Matcher)org.hamcrest.Matchers.containsString((String)"Expected")));
    }

    @Test
    public void testUsageWhenHelp() throws Exception {
        this.checkClass.mainImpl(new String[]{"--help"});
        ((Logger)Mockito.verify((Object)this.log)).error(Matchers.argThat((Matcher)org.hamcrest.Matchers.containsString((String)"Usage:")));
        ((Logger)Mockito.verify((Object)this.log, (VerificationMode)Mockito.never())).error(Matchers.argThat((Matcher)org.hamcrest.Matchers.containsString((String)"Expected")));
    }

    @Test
    public void testShowsCodeSource() throws Exception {
        this.checkClass.mainImpl(new String[]{this.getClass().getName()});
        ((Logger)Mockito.verify((Object)this.log, (VerificationMode)Mockito.atLeastOnce())).info(Matchers.argThat((Matcher)org.hamcrest.Matchers.containsString((String)this.getClass().getProtectionDomain().getCodeSource().getLocation().toString())));
    }

    @Test
    public void testErrorIfClassNotFound() throws Exception {
        this.checkClass.mainImpl(new String[]{"some.NonExistingClass"});
        ((Logger)Mockito.verify((Object)this.log, (VerificationMode)Mockito.atLeastOnce())).error(Matchers.argThat((Matcher)org.hamcrest.Matchers.containsString((String)"ClassNotFoundException")));
    }
}

