/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.atlassian.core.util.StringUtils;
import com.cenqua.fisheye.ctl.BaseCommand;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class BaseCommandTest {
    @Test
    public void testOverrideInstanceHome() throws IOException {
        Result r = this.callOverrideFishEyeInst(new String[]{"foo", "bar", "--fisheye-inst", ".", "baz"});
        Assert.assertEquals((long)3L, (long)r.argsList.size());
        Assert.assertTrue((boolean)r.returnValue);
        Assert.assertEquals((long)0L, (long)r.errors.size());
        r = this.callOverrideFishEyeInst(new String[]{"foo", "bar", "--fisheye-inst", "/xyzzy", "baz"});
        Assert.assertEquals((long)5L, (long)r.argsList.size());
        Assert.assertFalse((boolean)r.returnValue);
        Assert.assertEquals((Object)"--fisheye-inst argument '/xyzzy' does not exist\n", (Object)StringUtils.normalise((String)r.errors.toString()));
        r = this.callOverrideFishEyeInst(new String[]{"foo", "bar", "--fisheye-inst"});
        Assert.assertEquals((long)3L, (long)r.argsList.size());
        Assert.assertFalse((boolean)r.returnValue);
        Assert.assertEquals((Object)"No argument provided to --fisheye-inst parameter\n", (Object)StringUtils.normalise((String)r.errors.toString()));
    }

    private Result callOverrideFishEyeInst(String[] args) throws IOException {
        Result r = new Result();
        r.argsList = new LinkedList<String>(Arrays.asList(args));
        r.errors = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(r.errors);
        r.returnValue = BaseCommand.overrideFishEyeInst(r.argsList, (PrintStream)ps);
        ps.flush();
        ps.close();
        r.errors.close();
        return r;
    }

    private static class Result {
        List<String> argsList;
        boolean returnValue;
        ByteArrayOutputStream errors;

        private Result() {
        }
    }
}

