/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.csindex;

import com.atlassian.fecru.search.index.service.LuceneTestUtil;
import com.atlassian.fecru.search.index.service.TestDocInfoManager;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.RecentChangesParams2;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.crossrepo.ChangesetDoc;
import com.cenqua.fisheye.crossrepo.ChangesetDocInfo;
import com.cenqua.fisheye.csindex.BaseRecentChangesSearcher2;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetImpl;
import com.cenqua.fisheye.rep.CommonProperties;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.util.SortedList;
import com.cenqua.fisheye.web.WaybackSpec;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class BaseRecentChangesSearcher2Test {
    public static final String REPOSITORY = "rep";
    BaseRecentChangesSearcher2<ChangeSet> searcher;
    @Mock
    LuceneConnection<CrossRepLuceneIndexes> lucene;
    @Mock
    RevisionCache cache;
    private TestDocInfoManager<ChangesetDocInfo> docInfoManager;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.cache.getRepositoryType()).thenReturn((Object)ScmType.GIT);
        RAMDirectory directory = new RAMDirectory();
        this.docInfoManager = LuceneTestUtil.newRAMDocInfoManager((Directory)directory);
        this.lucene = LuceneTestUtil.mockLuceneConnection((Directory)directory);
        this.searcher = new BaseRecentChangesSearcher2<ChangeSet>(this.lucene){

            protected Comparator<ChangeSet> getComparator(boolean towardsFuture) {
                return ChangeSet.COMPARE_TOWARDS_PAST;
            }

            protected ChangeSet transformResult(ChangeSet cs) throws DbException {
                return cs;
            }

            protected Long getDateOfLastItem(SortedList<ChangeSet> results) {
                return ((ChangeSet)results.getLast()).getDate();
            }

            protected RevisionCache getCache(String rep) {
                return BaseRecentChangesSearcher2Test.this.cache;
            }
        };
    }

    @Test
    public void searchesForBranchCommitsUsingLuceneIfBranchIndexed() throws Exception {
        RecentChangesParams2 params = this.makeBranchQuery("branch1");
        ChangeSet[] changeSets = new ChangeSet[]{this.mockCs(1, "master"), this.mockCs(2, "branch1", "master"), this.mockCs(3, "branch1")};
        this.indexChangesets(changeSets);
        this.addToCache(changeSets);
        List<String> changesetIds = this.findRecentChangeSetIds(params);
        Assert.assertThat(changesetIds, (Matcher)Matchers.contains((Object[])new String[]{"3", "2"}));
        this.verifyNeverCheckedBranchMembership(changeSets);
    }

    @Test
    public void searchesForBranchCommitsUsingLuceneIfBranchNotIndexedButOnFirstPage() throws Exception {
        Mockito.when((Object)this.cache.getScanProperty(CommonProperties.GIT_CHANGESETS_TO_REINDEX.value, 0L)).thenReturn((Object)1L);
        RecentChangesParams2 params = this.makeBranchQuery("branch1");
        params.setMaxReturn(1);
        this.indexChangesets(this.mockCs(1, "master"), this.mockCs(2, "master"), this.mockCs(3, "branch1"));
        ChangeSet[] changeSets = new ChangeSet[]{this.mockCs(1, "master"), this.mockCs(2, "master", "branch1"), this.mockCs(3, "branch1")};
        this.addToCache(changeSets);
        List<String> changesetIds = this.findRecentChangeSetIds(params);
        Assert.assertThat(changesetIds, (Matcher)Matchers.contains((Object[])new String[]{"3"}));
        this.verifyNeverCheckedBranchMembership(changeSets);
    }

    @Test
    public void searchesForBranchCommitsUsingCacheIfNotIndexed() throws Exception {
        Mockito.when((Object)this.cache.getScanProperty(CommonProperties.GIT_CHANGESETS_TO_REINDEX.value, 0L)).thenReturn((Object)1L);
        RecentChangesParams2 params = this.makeBranchQuery("branch1");
        params.setMaxDate(Long.valueOf(100L));
        this.indexChangesets(this.mockCs(1, "master"), this.mockCs(2, "master"), this.mockCs(3, new String[0]));
        this.addToCache(this.mockCs(1, "master"), this.mockCs(2, "master", "branch1"), this.mockCs(3, "branch1"));
        List<String> changesetIds = this.findRecentChangeSetIds(params);
        Assert.assertThat(changesetIds, (Matcher)Matchers.contains((Object[])new String[]{"3", "2"}));
    }

    @Test
    public void searchesFromMaxChangeset() throws Exception {
        ChangeSet[] changeSets = new ChangeSet[]{this.mockCs(5, 2000L, "master"), this.mockCs(4, 2000L, "master"), this.mockCs(3, 2000L, "master"), this.mockCs(2, 1000L, "master"), this.mockCs(1, 1000L, "master")};
        this.indexChangesets(changeSets);
        this.addToCache(changeSets);
        Assert.assertThat(this.findRecentChangeSetIdsForMaxChangeset(null, 1), (Matcher)Matchers.contains((Object[])new String[]{"5"}));
        Assert.assertThat(this.findRecentChangeSetIdsForMaxChangeset(changeSets[0], 1), (Matcher)Matchers.contains((Object[])new String[]{"4"}));
        Assert.assertThat(this.findRecentChangeSetIdsForMaxChangeset(changeSets[1], 1), (Matcher)Matchers.contains((Object[])new String[]{"3"}));
        Assert.assertThat(this.findRecentChangeSetIdsForMaxChangeset(changeSets[2], 1), (Matcher)Matchers.contains((Object[])new String[]{"2"}));
        Assert.assertThat(this.findRecentChangeSetIdsForMaxChangeset(changeSets[3], 1), (Matcher)Matchers.contains((Object[])new String[]{"1"}));
        Assert.assertThat(this.findRecentChangeSetIdsForMaxChangeset(null, 2), (Matcher)Matchers.contains((Object[])new String[]{"5", "4"}));
        Assert.assertThat(this.findRecentChangeSetIdsForMaxChangeset(changeSets[1], 2), (Matcher)Matchers.contains((Object[])new String[]{"3", "2"}));
        Assert.assertThat(this.findRecentChangeSetIdsForMaxChangeset(changeSets[3], 2), (Matcher)Matchers.contains((Object[])new String[]{"1"}));
        Assert.assertThat(this.findRecentChangeSetIdsForMaxChangeset(null, 3), (Matcher)Matchers.contains((Object[])new String[]{"5", "4", "3"}));
        Assert.assertThat(this.findRecentChangeSetIdsForMaxChangeset(changeSets[2], 3), (Matcher)Matchers.contains((Object[])new String[]{"2", "1"}));
    }

    private List<String> findRecentChangeSetIds(RecentChangesParams2 params) {
        return Lists.transform((List)this.searcher.findRecentChangeSets(REPOSITORY, params), (Function)ChangeSet.TO_CSID);
    }

    private List<String> findRecentChangeSetIdsForMaxChangeset(@Nullable ChangeSet maxChangeset, int maxReturn) {
        RecentChangesParams2 params = new RecentChangesParams2();
        params.setMaxReturn(maxReturn);
        if (maxChangeset != null) {
            params.setMaxChangeset(maxChangeset, false);
        }
        return this.findRecentChangeSetIds(params);
    }

    private RecentChangesParams2 makeBranchQuery(String branch1) {
        RecentChangesParams2 params = new RecentChangesParams2();
        WaybackSpec wbSpec = new WaybackSpec();
        wbSpec.setBranch(branch1);
        params.setWbFilter(wbSpec);
        return params;
    }

    private ChangeSet mockCs(int id, String ... branches) {
        return this.mockCs(id, 100L, branches);
    }

    private ChangeSet mockCs(int id, long timestamp, String ... branches) {
        DummyChangeSet cs = new DummyChangeSet();
        cs.setRepName(REPOSITORY);
        cs.setId(String.valueOf(id));
        cs.setDate(timestamp);
        cs.setAuthor("author");
        cs.setComment("msg");
        cs.setBranches((Collection)ImmutableList.copyOf((Object[])branches));
        return cs;
    }

    private void indexChangesets(ChangeSet ... changeSets) throws IOException {
        LuceneTestUtil.indexDocs(this.docInfoManager, Iterables.transform(Arrays.asList(changeSets), changeSet -> new ChangesetDocInfo(ChangesetDoc.fromChangeSet((ChangeSet)changeSet), false)));
    }

    private void addToCache(ChangeSet ... changeSets) {
        for (ChangeSet changeSet : changeSets) {
            Mockito.when((Object)this.cache.getChangeSet(changeSet.getId())).thenReturn((Object)changeSet);
        }
    }

    private void verifyNeverCheckedBranchMembership(ChangeSet[] changeSets) {
        for (ChangeSet changeSet : changeSets) {
            Assert.assertThat((String)("changeset " + changeSet.getId() + " number of isInBranch() calls"), (Object)((DummyChangeSet)changeSet).getIsInBranchCount(), (Matcher)Matchers.is((Object)0));
        }
    }

    static class DummyChangeSet<F extends FileRevision>
    extends ChangeSetImpl<F> {
        private int isInBranchCount = 0;

        public DummyChangeSet() {
            super(null, null, null);
        }

        public Iterable<Path> getPaths() {
            return Collections.emptyList();
        }

        public boolean isInBranch(String branchName) {
            ++this.isInBranchCount;
            return super.isInBranch(branchName);
        }

        public int getIsInBranchCount() {
            return this.isInBranchCount;
        }
    }
}

