/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.search.index.service.DocInfoManager;
import com.atlassian.fisheye.bucket.TimeZoneVariables;
import com.cenqua.crucible.util.DummyEventPublisher;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.crossrepo.PathDoc;
import com.cenqua.fisheye.crossrepo.PathDocInfo;
import com.cenqua.fisheye.crossrepo.PathDocInfoMatcher;
import com.cenqua.fisheye.crossrepo.PathIndexer;
import com.cenqua.fisheye.crossrepo.PathIndexerCache;
import com.cenqua.fisheye.crossrepo.PathQueryBuilder;
import com.cenqua.fisheye.lucene.writer.DefaultIndexWriterFactory;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DummyChangeSet;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.LogicalPathMatcher;
import com.cenqua.fisheye.rep.impl.CommonFileRevision;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.web.admin.actions.svn.SvnSymbolicHelper;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PathIndexerTest {
    private final Query allPathDocsQuery = PathQueryBuilder.newPathCrossRepoQueryBuilder().build();
    private IndexWriter indexWriter;
    private PathIndexer.PathDocBatch pathDocBatch;
    private SvnLogicalPathMatcher svnLogicalPathMatcher;
    private PathIndexerCache pathCache = new PathIndexerCache((EventPublisher)new DummyEventPublisher());

    @Before
    public void setUp() throws Exception {
        RAMDirectory ramDirectory = new RAMDirectory();
        this.indexWriter = new DefaultIndexWriterFactory().create((Directory)ramDirectory, null, true);
        SvnSymbolicHelper symHelper = new SvnSymbolicHelper();
        symHelper.setAutorules(true);
        this.svnLogicalPathMatcher = new SvnLogicalPathMatcher(symHelper.toXmlBean());
        Assert.assertThat((String)"index is empty on set up", (Object)this.indexWriter.numDocs(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testStoreSingleFile() throws Exception {
        this.pathDocBatch = new PathIndexer.PathDocBatch("repoA", (LogicalPathMatcher)this.svnLogicalPathMatcher);
        this.pathDocBatch.addFileRevision(this.makeFileRevision("/trunk/file.txt", 1), (ChangeSet)new TestChangeSet("cs:12", "repoA", new Date()));
        new PathIndexer.PathDocBatchWriterAction(this.pathDocBatch, null, this.pathCache).perform(this.indexWriter);
        this.indexWriter.commit();
        Assert.assertThat((String)"1 document written", (Object)this.indexWriter.numDocs(), (Matcher)CoreMatchers.is((Object)1));
        PathDocInfo fileDoc = (PathDocInfo)this.getDao().findDoc(PathQueryBuilder.generateFilenameQuery((String)"file.txt"), PathDocInfo.CONVERTER);
        Assert.assertThat((Object)fileDoc, (Matcher)new PathDocInfoMatcher.Builder().withPath("file.txt").withRepository("repoA").build());
    }

    @Test
    public void testStoreSingleFileAndItsParentFolder() throws Exception {
        this.pathDocBatch = new PathIndexer.PathDocBatch("repoXXX", (LogicalPathMatcher)this.svnLogicalPathMatcher);
        this.pathDocBatch.addFileRevision(this.makeFileRevision("/trunk/dir/subdir/SomeFile.java", 1), (ChangeSet)new TestChangeSet("432423", "repoXXX", new Date()));
        new PathIndexer.PathDocBatchWriterAction(this.pathDocBatch, null, this.pathCache).perform(this.indexWriter);
        this.indexWriter.commit();
        Assert.assertThat((String)"2 documents written (file and dir)", (Object)this.indexWriter.numDocs(), (Matcher)CoreMatchers.is((Object)2));
        Iterator docs = this.getDao().findDocs(this.allPathDocsQuery, PathDocInfo.CONVERTER, 10).iterator();
        ArrayList allDocs = Lists.newArrayList(docs);
        Assert.assertThat((Object)allDocs, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat((Object)allDocs, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{new PathDocInfoMatcher.Builder().withPath("dir/subdir/SomeFile.java").withRepository("repoXXX").build(), new PathDocInfoMatcher.Builder().withPath("dir/subdir").withRepository("repoXXX").build()}));
    }

    @Test
    public void testOnlyNewestFileStored() throws Exception {
        Calendar cal = GregorianCalendar.getInstance();
        Date laterDate = cal.getTime();
        cal.add(5, -1);
        Date earlierDate = cal.getTime();
        this.pathDocBatch = new PathIndexer.PathDocBatch("repo", (LogicalPathMatcher)this.svnLogicalPathMatcher);
        this.pathDocBatch.addFileRevision(this.makeFileRevision("/trunk/README.txt", 1), (ChangeSet)new TestChangeSet("12", "repo", earlierDate));
        new PathIndexer.PathDocBatchWriterAction(this.pathDocBatch, null, this.pathCache).perform(this.indexWriter);
        this.indexWriter.commit();
        Assert.assertThat((String)"1st document written", (Object)this.indexWriter.maxDoc(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"Only one document should be present at all times", (Object)this.indexWriter.numDocs(), (Matcher)CoreMatchers.is((Object)1));
        this.pathDocBatch.clear();
        this.pathDocBatch.addFileRevision(this.makeFileRevision("/trunk/README.txt", 1), (ChangeSet)new TestChangeSet("24", "repo", laterDate));
        new PathIndexer.PathDocBatchWriterAction(this.pathDocBatch, null, this.pathCache).perform(this.indexWriter);
        this.indexWriter.commit();
        Assert.assertThat((String)"Only one document should be present at all times", (Object)this.indexWriter.numDocs(), (Matcher)CoreMatchers.is((Object)1));
        PathDocInfo doc2 = (PathDocInfo)this.getDao().findDoc(this.allPathDocsQuery, PathDocInfo.CONVERTER);
        Assert.assertThat((String)"document last update date should be updated, this was newer changeset", (Object)doc2, (Matcher)new PathDocInfoMatcher.Builder().withPath("README.txt").withRepository("repo").build());
        ScoreDoc earlierDoc = this.getDoc(this.allPathDocsQuery);
        this.pathDocBatch.clear();
        this.pathDocBatch.addFileRevision(this.makeFileRevision("/trunk/README.txt", 1), (ChangeSet)new TestChangeSet("6", "repo", earlierDate));
        new PathIndexer.PathDocBatchWriterAction(this.pathDocBatch, null, this.pathCache).perform(this.indexWriter);
        this.indexWriter.commit();
        ScoreDoc laterDoc = this.getDoc(this.allPathDocsQuery);
        Assert.assertThat((String)"document shouldn't be updated, this was older changeset", (Object)earlierDoc.doc, (Matcher)Matchers.equalTo((Object)laterDoc.doc));
    }

    private ScoreDoc getDoc(Query query) throws IOException {
        IndexSearcher searcher = new IndexSearcher(IndexReader.open((IndexWriter)this.indexWriter, (boolean)true));
        TopDocs topDocs = searcher.search(query, 1);
        if (topDocs.scoreDocs.length > 0) {
            return topDocs.scoreDocs[0];
        }
        return null;
    }

    @Test
    public void testEmptyLogicalPathsIndexedAsPhysical() throws Exception {
        this.pathDocBatch = new PathIndexer.PathDocBatch("repository", (LogicalPathMatcher)this.svnLogicalPathMatcher);
        this.pathDocBatch.addFileRevision(this.makeFileRevision("/branches/iterativeReviewsBranch", 2), (ChangeSet)new TestChangeSet("9600c2a5c015b8873a0067e2883a8c4d27ab8674", "repository", new Date()));
        new PathIndexer.PathDocBatchWriterAction(this.pathDocBatch, null, this.pathCache).perform(this.indexWriter);
        this.indexWriter.commit();
        PathDocInfo doc = (PathDocInfo)this.getDao().findDoc(this.allPathDocsQuery, PathDocInfo.CONVERTER);
        Assert.assertThat((Object)doc, (Matcher)new PathDocInfoMatcher.Builder().withPath("branches/iterativeReviewsBranch").withRepository("repository").build());
    }

    @Test
    public void testInMemoryDeduplicated() throws Exception {
        Calendar cal = GregorianCalendar.getInstance();
        Date laterDate = cal.getTime();
        cal.add(5, -1);
        Date earlierDate = cal.getTime();
        this.pathDocBatch = new PathIndexer.PathDocBatch("repo", (LogicalPathMatcher)this.svnLogicalPathMatcher);
        this.pathDocBatch.addFileRevision(this.makeFileRevision("/trunk/dir/README.txt", 1), (ChangeSet)new TestChangeSet("12", "repo", earlierDate));
        PathDocInfoMatcher earlierFilePathMatcher = new PathDocInfoMatcher.Builder().withPath("dir/README.txt").withRepository("repo").withDate(this.isRoundedDate(earlierDate)).withType(PathDoc.Type.FILE).build();
        PathDocInfoMatcher earlierParentDirMatcher = new PathDocInfoMatcher.Builder().withPath("dir").withRepository("repo").withDate(this.isRoundedDate(earlierDate)).withType(PathDoc.Type.DIR).build();
        Assert.assertThat((String)"right paths in batch", (Object)this.pathDocBatch, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{earlierFilePathMatcher, earlierParentDirMatcher}));
        Assert.assertThat((String)"2 paths in the batch", (Object)this.pathDocBatch.getSize(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((String)"no deduplication yet", (Object)this.pathDocBatch.getDeduplicatedCount(), (Matcher)CoreMatchers.is((Object)0));
        this.pathDocBatch.addFileRevision(this.makeFileRevision("/trunk/dir/README.txt", 1), (ChangeSet)new TestChangeSet("24", "repo", laterDate));
        PathDocInfoMatcher laterFilePathMatcher = new PathDocInfoMatcher.Builder().withPath("dir/README.txt").withRepository("repo").withDate(this.isRoundedDate(laterDate)).withType(PathDoc.Type.FILE).build();
        PathDocInfoMatcher laterParentDirMatcher = new PathDocInfoMatcher.Builder().withPath("dir").withRepository("repo").withDate(this.isRoundedDate(laterDate)).withType(PathDoc.Type.DIR).build();
        Assert.assertThat((String)"right paths in batch - with later dates", (Object)this.pathDocBatch, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{laterFilePathMatcher, laterParentDirMatcher}));
        Assert.assertThat((String)"still 2 paths in the batch", (Object)this.pathDocBatch.getSize(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((String)"2 deduplicated paths", (Object)this.pathDocBatch.getDeduplicatedCount(), (Matcher)CoreMatchers.is((Object)2));
        this.pathDocBatch.addFileRevision(this.makeFileRevision("/trunk/dir/README.txt", 1), (ChangeSet)new TestChangeSet("12", "repo", earlierDate));
        Assert.assertThat((String)"right paths in batch - with later dates", (Object)this.pathDocBatch, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{laterFilePathMatcher, laterParentDirMatcher}));
        Assert.assertThat((String)"still 2 paths in the batch", (Object)this.pathDocBatch.getSize(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((String)"4 deduplicated paths", (Object)this.pathDocBatch.getDeduplicatedCount(), (Matcher)CoreMatchers.is((Object)4));
    }

    private Matcher<Date> isRoundedDate(Date date) {
        return CoreMatchers.is((Object)TimeZoneVariables.hoursToDate((int)TimeZoneVariables.reduceMillisToHours((long)date.getTime())));
    }

    @Test
    public void testPathTypeMayChange() throws Exception {
        Calendar cal = GregorianCalendar.getInstance();
        Date laterDate = cal.getTime();
        cal.add(5, -1);
        Date earlierDate = cal.getTime();
        cal.add(5, -2);
        Date evenEarlierDate = cal.getTime();
        this.pathDocBatch = new PathIndexer.PathDocBatch("repo", (LogicalPathMatcher)this.svnLogicalPathMatcher);
        this.pathDocBatch.addFileRevision(this.makeFileRevision("/trunk/something", 1), (ChangeSet)new TestChangeSet("12", "repo", earlierDate));
        PathDocInfoMatcher earlierPathMatcher = new PathDocInfoMatcher.Builder().withPath("something").withRepository("repo").withDate(this.isRoundedDate(earlierDate)).withType(PathDoc.Type.FILE).build();
        Assert.assertThat((String)"path is a file", (Object)this.pathDocBatch, (Matcher)Matchers.contains((Matcher)earlierPathMatcher));
        this.pathDocBatch.addFileRevision(this.makeFileRevision("/trunk/something", 2), (ChangeSet)new TestChangeSet("6", "repo", evenEarlierDate));
        Assert.assertThat((String)"path is still a file, that was older change", (Object)this.pathDocBatch, (Matcher)Matchers.contains((Matcher)earlierPathMatcher));
        this.pathDocBatch.addFileRevision(this.makeFileRevision("/trunk/something", 2), (ChangeSet)new TestChangeSet("24", "repo", laterDate));
        PathDocInfoMatcher laterPathMatcher = new PathDocInfoMatcher.Builder().withPath("something").withRepository("repo").withDate(this.isRoundedDate(laterDate)).withType(PathDoc.Type.DIR).build();
        Assert.assertThat((String)"path is now a dir", (Object)this.pathDocBatch, (Matcher)Matchers.contains((Matcher)laterPathMatcher));
    }

    @Test
    public void testClear() throws Exception {
        this.pathDocBatch = new PathIndexer.PathDocBatch("repo", (LogicalPathMatcher)this.svnLogicalPathMatcher);
        Date date = new Date();
        this.pathDocBatch.addFileRevision(this.makeFileRevision("/trunk/README.txt", 1), (ChangeSet)new TestChangeSet("12", "repo", date));
        Assert.assertThat((String)"1 path in the batch", (Object)this.pathDocBatch.getSize(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"no deduplication yet", (Object)this.pathDocBatch.getDeduplicatedCount(), (Matcher)CoreMatchers.is((Object)0));
        this.pathDocBatch.addFileRevision(this.makeFileRevision("/trunk/README.txt", 1), (ChangeSet)new TestChangeSet("12", "repo", date));
        Assert.assertThat((String)"still 1 path in the batch", (Object)this.pathDocBatch.getSize(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"1 deduplicated path", (Object)this.pathDocBatch.getDeduplicatedCount(), (Matcher)CoreMatchers.is((Object)1));
        this.pathDocBatch.clear();
        Assert.assertThat((String)"batch is empty", (Object)this.pathDocBatch.getSize(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((String)"batch is empty", (Object)this.pathDocBatch.isEmpty(), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((String)"no deduplicated paths", (Object)this.pathDocBatch.getDeduplicatedCount(), (Matcher)CoreMatchers.is((Object)0));
    }

    private FileRevision makeFileRevision(String path, int fileType) {
        TestFileRevision fr = new TestFileRevision();
        fr.setPath(new Path((CharSequence)path));
        fr.setFileType(fileType);
        return fr;
    }

    public DocInfoManager<PathDocInfo> getDao() throws IOException {
        return new DocInfoManager(this.indexWriter, IndexReader.open((IndexWriter)this.indexWriter, (boolean)true));
    }

    static class TestFileRevision
    extends CommonFileRevision {
        TestFileRevision() {
        }
    }

    static class TestChangeSet
    extends DummyChangeSet {
        TestChangeSet(String csid, String repoName, Date date) {
            this.setId(csid);
            this.setRepName(repoName);
            this.setDate(date.getTime());
        }
    }
}

