/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.fecru.search.index.model.DocInfo;
import com.atlassian.fecru.search.index.service.LuceneTestUtil;
import com.atlassian.fecru.search.index.service.TestDocInfoManager;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.crossrepo.PathDoc;
import com.cenqua.fisheye.crossrepo.PathDocInfo;
import com.cenqua.fisheye.crossrepo.PathDocInfoMatcher;
import com.cenqua.fisheye.crossrepo.PathQueryBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PathDocInfoTest {
    TestDocInfoManager<PathDocInfo> dao;
    private ImmutableList<PathDocInfo> testPaths;

    @Before
    public void setUp() throws Exception {
        this.dao = LuceneTestUtil.newRAMDocInfoManager();
        this.testPaths = ImmutableList.of((Object)this.makePathCrossRepoDocInfo("dir/file.txt", PathDoc.Type.FILE, "repo"), (Object)this.makePathCrossRepoDocInfo("dir", PathDoc.Type.DIR, "repo"), (Object)this.makePathCrossRepoDocInfo("ROOT.txt", PathDoc.Type.FILE, "repo"), (Object)this.makePathCrossRepoDocInfo("dir/anotherFile.txt", PathDoc.Type.FILE, "anotherRepo"));
        for (PathDocInfo testPath : this.testPaths) {
            this.dao.addDoc((DocInfo)testPath);
        }
        this.dao.commit();
    }

    private PathDocInfo makePathCrossRepoDocInfo(String path, PathDoc.Type type, String repo) {
        return PathDocInfo.fromPathDoc((PathDoc)new PathDoc(new Path((CharSequence)path), type, new Date()), (String)repo);
    }

    @Test
    public void testGetKeyTerm() throws Exception {
        for (PathDocInfo testPath : this.testPaths) {
            ArrayList docs = Lists.newArrayList((Iterable)this.dao.findDocs((Query)new TermQuery(testPath.getKeyTerm()), PathDocInfo.CONVERTER, 10));
            Assert.assertThat((String)("one match found for each term: " + testPath), (Object)docs, (Matcher)Matchers.hasSize((int)1));
            Assert.assertThat((String)"it matches expected document", docs.iterator().next(), (Matcher)new PathDocInfoMatcher.Builder().withPath(testPath.getPath()).withRepository(testPath.getRepository()).build());
        }
    }

    @Test
    public void testIndexing() throws Exception {
        Assert.assertThat((String)"3 documents in 'repo' repo", (Object)this.dao.countDocs(((PathQueryBuilder)PathQueryBuilder.newPathCrossRepoQueryBuilder().fromTheseRepos(Collections.singletonList("repo"))).build()), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((String)"1 document in 'anotherRepo' repo", (Object)this.dao.countDocs(((PathQueryBuilder)PathQueryBuilder.newPathCrossRepoQueryBuilder().fromTheseRepos(Collections.singletonList("anotherRepo"))).build()), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((String)"2 documents in /dir folder in 'repo' repo", (Object)this.dao.countDocs(((PathQueryBuilder)PathQueryBuilder.newPathCrossRepoQueryBuilder().fromTheseRepos(Collections.singletonList("repo"))).queryByPath("dir/**").build()), (Matcher)CoreMatchers.is((Object)2));
    }
}

