/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.cenqua.fisheye.crossrepo.PathDoc;
import com.cenqua.fisheye.crossrepo.PathDocInfo;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class PathDocInfoMatcher
extends TypeSafeMatcher<PathDocInfo> {
    private final Matcher<String> repoNameMatcher;
    private final Matcher<String> pathMatcher;
    private final Matcher<Date> dateMatcher;
    private final Matcher<String> typeMatcher;

    private PathDocInfoMatcher(Matcher<String> repoNameMatcher, Matcher<String> pathMatcher, Matcher<Date> dateMatcher, Matcher<String> typeMatcher) {
        super(PathDocInfo.class);
        this.repoNameMatcher = repoNameMatcher;
        this.pathMatcher = pathMatcher;
        this.dateMatcher = dateMatcher;
        this.typeMatcher = typeMatcher;
    }

    protected boolean matchesSafely(PathDocInfo item) {
        return this.repoNameMatcher.matches((Object)item.getRepository()) && this.pathMatcher.matches((Object)item.getPath()) && this.dateMatcher.matches((Object)item.getLastModifiedDate()) && this.typeMatcher.matches((Object)item.getType());
    }

    public void describeTo(Description description) {
        description.appendText("expected pathMatcher: ");
        this.pathMatcher.describeTo(description);
        description.appendText(" and repository: ");
        this.repoNameMatcher.describeTo(description);
        description.appendText(" and date: ");
        this.dateMatcher.describeTo(description);
        description.appendText(" and type: ");
        this.typeMatcher.describeTo(description);
    }

    public static class Builder {
        private Matcher<String> repoNameMatcher = Matchers.any(String.class);
        private Matcher<String> pathMatcher = Matchers.any(String.class);
        private Matcher<Date> dateMatcher = Matchers.anyOf((Matcher)Matchers.any(Date.class), (Matcher)Matchers.nullValue());
        private Matcher<String> typeMatcher = Matchers.anyOf((Matcher)Matchers.any(String.class), (Matcher)Matchers.nullValue());

        public Builder withRepository(Matcher<String> repoNameMatcher) {
            Preconditions.checkNotNull(repoNameMatcher);
            this.repoNameMatcher = repoNameMatcher;
            return this;
        }

        public Builder withRepository(String repoName) {
            return this.withRepository((Matcher<String>)Matchers.is((Object)repoName));
        }

        public Builder withPath(Matcher<String> pathMatcher) {
            Preconditions.checkNotNull(pathMatcher);
            this.pathMatcher = pathMatcher;
            return this;
        }

        public Builder withPath(String path) {
            return this.withPath((Matcher<String>)Matchers.is((Object)path));
        }

        public Builder withDate(Matcher<Date> dateMatcher) {
            Preconditions.checkNotNull(dateMatcher);
            this.dateMatcher = dateMatcher;
            return this;
        }

        public Builder withDateAfter(Date date) {
            return this.withDate((Matcher<Date>)Matchers.greaterThan((Comparable)date));
        }

        public Builder withDateNotAfter(Date date) {
            return this.withDate((Matcher<Date>)Matchers.not((Matcher)Matchers.greaterThan((Comparable)date)));
        }

        public Builder withType(Matcher<String> typeMatcher) {
            Preconditions.checkNotNull(typeMatcher);
            this.typeMatcher = typeMatcher;
            return this;
        }

        public Builder withType(PathDoc.Type type) {
            return this.withType((Matcher<String>)Matchers.is((Object)type.getCode()));
        }

        public PathDocInfoMatcher build() {
            return new PathDocInfoMatcher(this.repoNameMatcher, this.pathMatcher, this.dateMatcher, this.typeMatcher);
        }
    }
}

