/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.crucible.explorers.ChangeSetPair;
import com.atlassian.fecru.search.index.model.DocInfo;
import com.atlassian.fecru.search.index.service.LuceneTestUtil;
import com.atlassian.fecru.search.index.service.TestDocInfoManager;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.atlassian.fisheye.spi.services.RepositoryService;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.crossrepo.ChangesetCannedQueries;
import com.cenqua.fisheye.crossrepo.ChangesetDoc;
import com.cenqua.fisheye.crossrepo.ChangesetDocInfo;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.crossrepo.ChangesetSearcher;
import com.cenqua.fisheye.crossrepo.DefaultChangesetSearcher;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.ChangeSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class DefaultChangesetSearcherTest {
    private ChangesetSearcher changesetSearcher;
    private TestDocInfoManager<ChangesetDocInfo> docInfoManager;
    private RepositoryService repositoryService = (RepositoryService)Mockito.mock(RepositoryService.class);

    @Before
    public void setUp() throws Exception {
        RAMDirectory dir = new RAMDirectory();
        this.docInfoManager = LuceneTestUtil.newRAMDocInfoManager((Directory)dir);
        CrossRepLuceneIndex index = (CrossRepLuceneIndex)Mockito.mock(CrossRepLuceneIndex.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Answer performAction = invocation -> {
            LuceneConnection.IndexSearcherAction action = (LuceneConnection.IndexSearcherAction)invocation.getArguments()[1];
            return action.perform(new IndexSearcher(IndexReader.open((Directory)dir)));
        };
        Mockito.when((Object)index.getConnection().withIndexSearcher((LuceneConnection.IndexConfig)org.mockito.Matchers.eq((Object)CrossRepLuceneIndexes.METADATA), (LuceneConnection.IndexSearcherAction)org.mockito.Matchers.any(LuceneConnection.IndexSearcherAction.class))).thenAnswer(performAction);
        this.changesetSearcher = new DefaultChangesetSearcher(index, this.repositoryService);
    }

    @Test
    public void testGetChangesetsForQuery_singleIssue() throws Exception {
        Mockito.when((Object)this.repositoryService.isRepositoryAccessible(org.mockito.Matchers.anyString())).thenReturn((Object)true);
        this.indexChangesets();
        List changesets = this.changesetSearcher.getChangesetsForQuery(ChangesetCannedQueries.changesetsForIssueKeys(Collections.singleton("FOO-1")));
        Assert.assertThat((Object)changesets, (Matcher)Matchers.containsInAnyOrder((Object[])new ChangeSetPair[]{ChangeSetPair.newInstance((String)"rep1", (String)"1"), ChangeSetPair.newInstance((String)"rep3", (String)"7"), ChangeSetPair.newInstance((String)"rep4", (String)"4")}));
    }

    @Test
    public void testGetChangesetsForQuery_doesntMatchReviewKeys() throws Exception {
        Mockito.when((Object)this.repositoryService.isRepositoryAccessible(org.mockito.Matchers.anyString())).thenReturn((Object)true);
        this.indexChangesets();
        List changesets = this.changesetSearcher.getChangesetsForQuery(ChangesetCannedQueries.changesetsForIssueKeys(Collections.singleton("FE-12")));
        Assert.assertThat((Object)changesets, (Matcher)Matchers.containsInAnyOrder((Object[])new ChangeSetPair[]{ChangeSetPair.newInstance((String)"rep3", (String)"11")}));
    }

    @Test
    public void testGetChangesetsForQuery_checksAccesibility() throws Exception {
        Mockito.when((Object)this.repositoryService.isRepositoryAccessible("rep1")).thenReturn((Object)true);
        this.indexChangesets();
        List changesets = this.changesetSearcher.getChangesetsForQuery(ChangesetCannedQueries.changesetsForIssueKeys(Collections.singleton("FOO-1")));
        Assert.assertThat((Object)changesets, (Matcher)Matchers.containsInAnyOrder((Object[])new ChangeSetPair[]{ChangeSetPair.newInstance((String)"rep1", (String)"1")}));
    }

    @Test
    public void testGetChangesetsForQuery_manyIssues() throws Exception {
        this.indexChangesets();
        Mockito.when((Object)this.repositoryService.isRepositoryAccessible(org.mockito.Matchers.anyString())).thenReturn((Object)true);
        List changesets = this.changesetSearcher.getChangesetsForQuery(ChangesetCannedQueries.changesetsForIssueKeys(Arrays.asList("FOO-2", "FOO-1")));
        Assert.assertThat((Object)changesets, (Matcher)Matchers.containsInAnyOrder((Object[])new ChangeSetPair[]{ChangeSetPair.newInstance((String)"rep1", (String)"1"), ChangeSetPair.newInstance((String)"rep3", (String)"7"), ChangeSetPair.newInstance((String)"rep4", (String)"4"), ChangeSetPair.newInstance((String)"rep2", (String)"2"), ChangeSetPair.newInstance((String)"rep2", (String)"6")}));
    }

    @Test
    public void testGetChangesetsForQuery_allFromRepo() throws Exception {
        this.indexChangesets();
        Mockito.when((Object)this.repositoryService.isRepositoryAccessible(org.mockito.Matchers.anyString())).thenReturn((Object)true);
        List changesets = this.changesetSearcher.getChangesetsForQuery(ChangesetQueryBuilder.newBuilder((String)"rep1"));
        Assert.assertThat((Object)changesets, (Matcher)Matchers.containsInAnyOrder((Object[])new ChangeSetPair[]{ChangeSetPair.newInstance((String)"rep1", (String)"1"), ChangeSetPair.newInstance((String)"rep1", (String)"5")}));
    }

    @Test
    public void testGetChangesetsForQuery_all() throws Exception {
        this.indexChangesets();
        Mockito.when((Object)this.repositoryService.isRepositoryAccessible(org.mockito.Matchers.anyString())).thenReturn((Object)true);
        List changesets = this.changesetSearcher.getChangesetsForQuery(ChangesetQueryBuilder.newCrossRepoBuilder().changesetsOnly());
        Assert.assertThat((Object)changesets, (Matcher)Matchers.hasSize((int)11));
    }

    @Test
    public void testGetChangesetsForQuery_sort() throws Exception {
        long dateOlder = 0L;
        long dateNewer = 1000000L;
        String repoX = "repoX";
        String branchX = "branchX";
        this.docInfoManager.addDoc((DocInfo)new ChangesetDocInfo(ChangesetDoc.fromChangeSet((ChangeSet)FisheyeTestUtil.mockChangeSet(repoX, "commit1", "authorA", "comment 1", dateOlder, branchX)), false));
        this.docInfoManager.addDoc((DocInfo)new ChangesetDocInfo(ChangesetDoc.fromChangeSet((ChangeSet)FisheyeTestUtil.mockChangeSet(repoX, "commit2", "authorA", "comment 2", dateNewer, branchX)), false));
        this.docInfoManager.commit();
        Mockito.when((Object)this.repositoryService.isRepositoryAccessible(org.mockito.Matchers.anyString())).thenReturn((Object)true);
        ChangesetQueryBuilder queryBuilder = ChangesetQueryBuilder.newBuilder((String)repoX).onBranch(branchX);
        List changesets = this.changesetSearcher.getChangesetsForQuery(queryBuilder, 1, SearchSortOrder.TOWARDS_PAST);
        Assert.assertThat((Object)changesets, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((ChangeSetPair)changesets.get(0)).getCsid(), (Matcher)Matchers.is((Object)"commit2"));
    }

    private void indexChangesets() throws IOException {
        this.docInfoManager.addDoc((DocInfo)new ChangesetDocInfo(ChangesetDoc.fromChangeSet((ChangeSet)FisheyeTestUtil.mockChangeSet("rep1", "1", "FOO-1: fix things")), false));
        this.docInfoManager.addDoc((DocInfo)new ChangesetDocInfo(ChangesetDoc.fromChangeSet((ChangeSet)FisheyeTestUtil.mockChangeSet("rep2", "2", "FOO-2: fix things")), false));
        this.docInfoManager.addDoc((DocInfo)new ChangesetDocInfo(ChangesetDoc.fromChangeSet((ChangeSet)FisheyeTestUtil.mockChangeSet("rep3", "3", "FOO: fix things")), false));
        this.docInfoManager.addDoc((DocInfo)new ChangesetDocInfo(ChangesetDoc.fromChangeSet((ChangeSet)FisheyeTestUtil.mockChangeSet("rep4", "4", "fix things: FOO-1")), false));
        this.docInfoManager.addDoc((DocInfo)new ChangesetDocInfo(ChangesetDoc.fromChangeSet((ChangeSet)FisheyeTestUtil.mockChangeSet("rep1", "5", "fix things")), false));
        this.docInfoManager.addDoc((DocInfo)new ChangesetDocInfo(ChangesetDoc.fromChangeSet((ChangeSet)FisheyeTestUtil.mockChangeSet("rep2", "6", "fix FOO-2 things")), false));
        this.docInfoManager.addDoc((DocInfo)new ChangesetDocInfo(ChangesetDoc.fromChangeSet((ChangeSet)FisheyeTestUtil.mockChangeSet("rep3", "7", "fix FOO-1 things FOO-2")), false));
        this.docInfoManager.addDoc((DocInfo)new ChangesetDocInfo(ChangesetDoc.fromChangeSet((ChangeSet)FisheyeTestUtil.mockChangeSet("rep3", "8", "unrelated")), false));
        this.docInfoManager.addDoc((DocInfo)new ChangesetDocInfo(ChangesetDoc.fromChangeSet((ChangeSet)FisheyeTestUtil.mockChangeSet("rep3", "9", "unrelated")), false));
        this.docInfoManager.addDoc((DocInfo)new ChangesetDocInfo(ChangesetDoc.fromChangeSet((ChangeSet)FisheyeTestUtil.mockChangeSet("rep3", "10", "ssss CR-FE-12")), false));
        this.docInfoManager.addDoc((DocInfo)new ChangesetDocInfo(ChangesetDoc.fromChangeSet((ChangeSet)FisheyeTestUtil.mockChangeSet("rep3", "11", "aaa FE-12")), false));
        this.docInfoManager.commit();
    }
}

