/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.fecru.search.index.model.DocInfo;
import com.atlassian.fecru.search.index.service.TestDocInfoManager;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.crossrepo.ChangesetDoc;
import com.cenqua.fisheye.crossrepo.ChangesetDocInfo;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.lucene.writer.DefaultIndexWriterFactory;
import com.cenqua.fisheye.rep.ChangeSet;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChangesetQueryBuilderTest {
    IndexWriter writer;
    IndexReader reader;
    private TestDocInfoManager<ChangesetDocInfo> manager;

    @Before
    public void setUp() throws Exception {
        IndexWriter writer = new DefaultIndexWriterFactory().create((Directory)new RAMDirectory(), (Analyzer)new KeywordAnalyzer(), true);
        writer.commit();
        this.manager = new TestDocInfoManager(writer, IndexReader.open((IndexWriter)writer, (boolean)true));
    }

    private ChangesetDocInfo makeDoc(String repo, String csid, String msg) {
        return new ChangesetDocInfo(ChangesetDoc.fromChangeSet((ChangeSet)FisheyeTestUtil.mockChangeSet(repo, csid, "author1", msg, 1000L, new String[0])), false);
    }

    @Test
    public void testOutOfReposWithNoRepositoryConstraints() throws Exception {
        this.manager.addDoc((DocInfo)this.makeDoc("rep1", "1", "test"));
        this.manager.addDoc((DocInfo)this.makeDoc("rep2", "2", "test"));
        this.manager.commit();
        Query query = ((ChangesetQueryBuilder.QueryBuilder)((ChangesetQueryBuilder.QueryBuilder)ChangesetQueryBuilder.newCrossRepoBuilder().withComment("test")).optimalRepositoryQuery((Collection)ImmutableList.of(), (Collection)ImmutableList.of((Object)"rep1", (Object)"rep2"))).build();
        ImmutableList results = ImmutableList.copyOf((Collection)this.manager.findDocs(query, ChangesetDocInfo.CONVERTER, Integer.MAX_VALUE));
        Assert.assertTrue((boolean)results.isEmpty());
    }

    @Test
    public void testOutOfReposRepositoryConstraints() throws Exception {
        this.manager.addDoc((DocInfo)this.makeDoc("rep1", "1", "test"));
        this.manager.addDoc((DocInfo)this.makeDoc("rep2", "2", "test"));
        this.manager.commit();
        Query query = ((ChangesetQueryBuilder.QueryBuilder)((ChangesetQueryBuilder.QueryBuilder)ChangesetQueryBuilder.newCrossRepoBuilder().withComment("test")).optimalRepositoryQuery((Collection)ImmutableList.of((Object)"rep1"), (Collection)ImmutableList.of((Object)"rep2"))).build();
        ImmutableList results = ImmutableList.copyOf((Collection)this.manager.findDocs(query, ChangesetDocInfo.CONVERTER, Integer.MAX_VALUE));
        Assert.assertThat((Object)results, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((ChangesetDocInfo)results.get(0)).getRepository(), (Matcher)Matchers.equalTo((Object)"rep1"));
        Assert.assertThat((Object)((ChangesetDocInfo)results.get(0)).getChangesetId(), (Matcher)Matchers.equalTo((Object)"1"));
    }

    @Test
    public void testOutOfReposWithAllRepos() throws Exception {
        this.manager.addDoc((DocInfo)this.makeDoc("rep1", "1", "test"));
        this.manager.addDoc((DocInfo)this.makeDoc("rep2", "2", "test"));
        this.manager.commit();
        Query query = ((ChangesetQueryBuilder.QueryBuilder)((ChangesetQueryBuilder.QueryBuilder)ChangesetQueryBuilder.newCrossRepoBuilder().withComment("test")).optimalRepositoryQuery((Collection)ImmutableList.of((Object)"rep1", (Object)"rep2"), (Collection)ImmutableList.of())).build();
        ImmutableList results = ImmutableList.copyOf((Collection)this.manager.findDocs(query, ChangesetDocInfo.CONVERTER, Integer.MAX_VALUE));
        Assert.assertThat((Object)results, (Matcher)Matchers.hasSize((int)2));
    }
}

