/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.fecru.search.index.model.DocInfo;
import com.atlassian.fecru.search.index.service.LuceneTestUtil;
import com.atlassian.fecru.search.index.service.TestDocInfoManager;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.crossrepo.ChangesetDoc;
import com.cenqua.fisheye.crossrepo.ChangesetDocInfo;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DummyChangeSet;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChangesetDocInfoTest {
    TestDocInfoManager<ChangesetDocInfo> dao;

    @Before
    public void setUp() throws Exception {
        this.dao = LuceneTestUtil.newRAMDocInfoManager();
    }

    @Test
    public void testSearch_authorsCaseInsensitive() throws Exception {
        this.addDoc(this.dao, new TestChangeSet("csid1", "Lukasz Pater <lpater@atlassian.com>", "commit log message", "someRepo"), false);
        this.addDoc(this.dao, new TestChangeSet("csid2", "another author", "commit log message", "someRepo"), false);
        this.addDoc(this.dao, new TestChangeSet("csid3", "lukasz", "commit log message", "someRepo"), false);
        this.dao.commit();
        int sameCase = this.dao.countDocs(((ChangesetQueryBuilder.QueryBuilder)((ChangesetQueryBuilder.QueryBuilder)ChangesetQueryBuilder.newCrossRepoBuilder().changesetsOnly()).withCommitter("Lukasz Pater <lpater@atlassian.com>")).build());
        int lowerCase = this.dao.countDocs(((ChangesetQueryBuilder.QueryBuilder)((ChangesetQueryBuilder.QueryBuilder)ChangesetQueryBuilder.newCrossRepoBuilder().changesetsOnly()).withCommitter("lukasz pater <lpater@atlassian.com>")).build());
        int upperCase = this.dao.countDocs(((ChangesetQueryBuilder.QueryBuilder)((ChangesetQueryBuilder.QueryBuilder)ChangesetQueryBuilder.newCrossRepoBuilder().changesetsOnly()).withCommitter("LUKASZ PATER <LPATER@ATLASSIAN.COM>")).build());
        Assert.assertEquals((long)1L, (long)sameCase);
        Assert.assertEquals((long)1L, (long)lowerCase);
        Assert.assertEquals((long)1L, (long)upperCase);
    }

    private void addDoc(TestDocInfoManager<ChangesetDocInfo> dao, TestChangeSet changeSet, boolean isUpdate) throws IOException {
        dao.addDoc((DocInfo)new ChangesetDocInfo(ChangesetDoc.fromChangeSet((ChangeSet)changeSet), isUpdate));
    }

    @Test
    public void testIndexChangeset() throws Exception {
        this.addDoc(this.dao, new TestChangeSet("csid", "author", "commit log message", "someRepo"), false);
        this.dao.commit();
        Assert.assertThat((String)"lookup by changeset id", (Object)this.dao.countDocs(((ChangesetQueryBuilder.QueryBuilder)ChangesetQueryBuilder.newCrossRepoBuilder().changesetsOnly()).withChangeSetId("csid").build()), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((String)"lookup by commit log message", (Object)this.dao.countDocs(((ChangesetQueryBuilder.QueryBuilder)ChangesetQueryBuilder.newCrossRepoBuilder().changesetsOnly()).withCommentMatching("message", false).build()), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((String)"lookup by changeset author", (Object)this.dao.countDocs(((ChangesetQueryBuilder.QueryBuilder)((ChangesetQueryBuilder.QueryBuilder)ChangesetQueryBuilder.newCrossRepoBuilder().changesetsOnly()).withCommitter("author")).build()), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((String)"should find our changeset on path /dirA", (Object)this.dao.countDocs(ChangesetQueryBuilder.newBuilder((String)"someRepo").changesetsOnly().onPath(new Path((CharSequence)"/dirA")).build()), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((String)"should find our changeset on path /dirA/dir1", (Object)this.dao.countDocs(ChangesetQueryBuilder.newBuilder((String)"someRepo").changesetsOnly().onPath(new Path((CharSequence)"/dirA/dir1")).build()), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((String)"should not find our changeset on path /dirA/dirX", (Object)this.dao.countDocs(ChangesetQueryBuilder.newBuilder((String)"someRepo").changesetsOnly().onPath(new Path((CharSequence)"/dirA/dirX")).build()), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testQueryMatchesNonPhraseComments() throws Exception {
        this.addDoc(this.dao, new TestChangeSet("csid1", "Lukasz Pater <lpater@atlassian.com>", "commit", "someRepo"), false);
        this.addDoc(this.dao, new TestChangeSet("csid2", "Lukasz Pater <lpater@atlassian.com>", "commit log message", "someRepo"), false);
        this.addDoc(this.dao, new TestChangeSet("csid3", "Lukasz Pater <lpater@atlassian.com>", "log", "someRepo"), false);
        this.addDoc(this.dao, new TestChangeSet("csid4", "another author", "commit message", "someRepo"), false);
        this.addDoc(this.dao, new TestChangeSet("csid5", "Lukasz Pater <lpater@atlassian.com>", "message is is is is a thing thing or commit", "someRepo"), false);
        this.dao.commit();
        ImmutableList phraseMatches = ImmutableList.copyOf((Collection)this.dao.findDocs(ChangesetQueryBuilder.newCrossRepoBuilder().withCommentMatching("commit message", false).build(), ChangesetDocInfo.CONVERTER, 10));
        ImmutableList phraseAndWordMatches = ImmutableList.copyOf((Collection)this.dao.findDocs(ChangesetQueryBuilder.newCrossRepoBuilder().withCommentMatching("commit message", true).build(), ChangesetDocInfo.CONVERTER, 10));
        Assert.assertThat((Object)phraseMatches, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((ChangesetDocInfo)phraseMatches.get(0)).getChangesetId(), (Matcher)Matchers.equalTo((Object)"csid4"));
        Assert.assertThat((Object)phraseAndWordMatches, (Matcher)Matchers.hasSize((int)4));
        Assert.assertThat((Object)((ChangesetDocInfo)phraseAndWordMatches.get(0)).getChangesetId(), (Matcher)Matchers.equalTo((Object)"csid4"));
        Assert.assertThat((Object)((ChangesetDocInfo)phraseAndWordMatches.get(1)).getChangesetId(), (Matcher)Matchers.equalTo((Object)"csid2"));
        Assert.assertThat((Object)((ChangesetDocInfo)phraseAndWordMatches.get(2)).getChangesetId(), (Matcher)Matchers.equalTo((Object)"csid5"));
        Assert.assertThat((Object)((ChangesetDocInfo)phraseAndWordMatches.get(3)).getChangesetId(), (Matcher)Matchers.equalTo((Object)"csid1"));
    }

    static class TestChangeSet
    extends DummyChangeSet {
        TestChangeSet(String csid, String author, String comment, String repoName) {
            this.setId(csid);
            this.setAuthor(author);
            this.setComment(comment);
            this.setRepName(repoName);
            this.setDate(new Date().getTime());
        }

        public Iterable<Path> getPaths() {
            return Arrays.asList(new Path((CharSequence)"/dirA/dir1/build.xml"), new Path((CharSequence)"/dirA/dir2/README.txt"));
        }
    }
}

