/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.fecru.search.index.model.DocInfo;
import com.atlassian.fecru.search.index.service.LuceneTestUtil;
import com.atlassian.fecru.search.index.service.TestDocInfoManager;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.model.ChangesetComment;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.crossrepo.ChangesetCommentDoc;
import com.cenqua.fisheye.crossrepo.ChangesetCommentDocInfo;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DummyChangeSet;
import java.util.Arrays;
import java.util.Date;
import org.apache.lucene.search.Query;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChangesetCommentDocInfoTest {
    TestDocInfoManager<ChangesetCommentDocInfo> dao;

    @Before
    public void setUp() throws Exception {
        this.dao = LuceneTestUtil.newRAMDocInfoManager();
        TestChangeSet changeSet = new TestChangeSet("abcdef001", "someone", "fake changeset", "someRepo");
        ChangesetComment joesComment = new ChangesetComment(new FecruUser("joe"), changeSet.getRepName(), changeSet.getId(), "some comment", null, false, false);
        joesComment.setId(Integer.valueOf(13));
        this.dao.addDoc((DocInfo)new ChangesetCommentDocInfo(ChangesetCommentDoc.fromChangeSetComment((ChangeSet)changeSet, (ChangesetComment.Info)joesComment.toInfo())));
        ChangesetComment alexesComment = new ChangesetComment(new FecruUser("alex"), changeSet.getRepName(), changeSet.getId(), "another comment", null, false, false);
        alexesComment.setId(Integer.valueOf(21));
        this.dao.addDoc((DocInfo)new ChangesetCommentDocInfo(ChangesetCommentDoc.fromChangeSetComment((ChangeSet)changeSet, (ChangesetComment.Info)alexesComment.toInfo())));
        this.dao.commit();
    }

    @Test
    public void testIndexChangesetComment() throws Exception {
        Query joesCommentsQuery = ((ChangesetQueryBuilder.QueryBuilder)((ChangesetQueryBuilder.QueryBuilder)ChangesetQueryBuilder.newCrossRepoBuilder().changesetCommentsOnly()).commentsByUser("joe")).build();
        Assert.assertThat((String)"Exactly one joe's comment found", (Object)this.dao.countDocs(joesCommentsQuery), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((String)"joe's comment id matches", (Object)((ChangesetCommentDocInfo)this.dao.findDoc(joesCommentsQuery, ChangesetCommentDocInfo.ID_ONLY_CONVERTER)).getChangesetCommentId(), (Matcher)Matchers.is((Object)"13"));
        Query alexesCommentsQuery = ((ChangesetQueryBuilder.QueryBuilder)((ChangesetQueryBuilder.QueryBuilder)ChangesetQueryBuilder.newCrossRepoBuilder().changesetCommentsOnly()).commentsByUser("alex")).build();
        Assert.assertThat((String)"Exactly one alex'es comment found", (Object)this.dao.countDocs(alexesCommentsQuery), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((String)"alex'es comment id matches", (Object)((ChangesetCommentDocInfo)this.dao.findDoc(alexesCommentsQuery, ChangesetCommentDocInfo.ID_ONLY_CONVERTER)).getChangesetCommentId(), (Matcher)Matchers.is((Object)"21"));
    }

    static class TestChangeSet
    extends DummyChangeSet {
        TestChangeSet(String csid, String author, String comment, String repoName) {
            this.setId(csid);
            this.setAuthor(author);
            this.setComment(comment);
            this.setRepName(repoName);
            this.setDate(new Date().getTime());
        }

        public Iterable<Path> getPaths() {
            return Arrays.asList(new Path((CharSequence)"/dirA/dir1/build.xml"));
        }
    }
}

