/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.crossrepo.BranchDocInfo;
import com.cenqua.fisheye.crossrepo.BranchIndexer;
import com.cenqua.fisheye.crossrepo.BranchQueryBuilder;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.BranchState;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetResolver;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BranchIndexerTest {
    private File tempDir;
    private CrossRepLuceneIndex crossRepoLuceneIndex;
    private BranchIndexer branchIndexer;

    @Before
    public void setUp() throws Exception {
        this.tempDir = Files.createTempDir();
        this.crossRepoLuceneIndex = new CrossRepLuceneIndex(this.tempDir, true);
        this.branchIndexer = new BranchIndexer(this.crossRepoLuceneIndex);
    }

    @After
    public void tearDown() throws Exception {
        this.crossRepoLuceneIndex.close();
        FileUtils.deleteDirectory((File)this.tempDir);
    }

    @Test
    public void testIndexBranchesForChangeSets_picksHead() throws Exception {
        ChangeSet headOnA = FisheyeTestUtil.mockChangeSet("rep1", "cs1", "", "", 1000000L, "branchA", "branchB");
        ChangeSet headOnB = FisheyeTestUtil.mockChangeSet("rep1", "cs2", "", "", 2000000L, "branchA", "branchB");
        ChangeSetResolver<ChangeSet> cache = FisheyeTestUtil.mockChangeSetResolver(headOnA, headOnB);
        ImmutableSet branchSet = ImmutableSet.of((Object)new Branch("branchA", "cs1", BranchState.ACTIVE), (Object)new Branch("branchB", "cs2", BranchState.ACTIVE));
        this.branchIndexer.indexBranchesForChangeSetIds((Iterable)ImmutableList.of((Object)headOnA.getId(), (Object)headOnB.getId()), (Iterable)branchSet, cache, new RepositoryStatus("rep1"));
        this.crossRepoLuceneIndex.getConnection().withIndexSearcher((LuceneConnection.IndexConfig)CrossRepLuceneIndexes.METADATA, searcher -> {
            TopDocs a = searcher.search(this.queryBranch("rep1", "branchA"), 1);
            TopDocs b = searcher.search(this.queryBranch("rep1", "branchB"), 1);
            BranchDocInfo aDoc = BranchDocInfo.fromDocumentToBranchDocInfo((Document)searcher.doc(a.scoreDocs[0].doc));
            BranchDocInfo bDoc = BranchDocInfo.fromDocumentToBranchDocInfo((Document)searcher.doc(b.scoreDocs[0].doc));
            Assert.assertThat((Object)a.totalHits, (Matcher)Matchers.equalTo((Object)1));
            Assert.assertThat((Object)aDoc.getLastChangeSetId(), (Matcher)Matchers.equalTo((Object)headOnA.getId()));
            Assert.assertThat((Object)aDoc.getLastModified(), (Matcher)Matchers.equalTo((Object)headOnA.getDate()));
            Assert.assertThat((Object)b.totalHits, (Matcher)Matchers.equalTo((Object)1));
            Assert.assertThat((Object)bDoc.getLastChangeSetId(), (Matcher)Matchers.equalTo((Object)headOnB.getId()));
            Assert.assertThat((Object)bDoc.getLastModified(), (Matcher)Matchers.equalTo((Object)headOnB.getDate()));
            return null;
        });
    }

    @Test
    public void testIndexBranchesForChangeSets_indexesAndStores() throws Exception {
        ChangeSet changeSet = FisheyeTestUtil.mockChangeSet("rep1", "cs1", "", "", 1000000L, "branchA", "branchB");
        Branch branch = new Branch(changeSet.getBranch(), changeSet.getId(), BranchState.ACTIVE);
        this.branchIndexer.indexBranchesForChangeSetIds((Iterable)ImmutableList.of((Object)changeSet.getId()), (Iterable)ImmutableList.of((Object)branch), FisheyeTestUtil.mockChangeSetResolver(changeSet), new RepositoryStatus("rep1"));
        this.crossRepoLuceneIndex.getConnection().withIndexSearcher((LuceneConnection.IndexConfig)CrossRepLuceneIndexes.METADATA, searcher -> {
            this.assertNonEmptyQuery(searcher, this.queryBranch(changeSet.getRepName(), changeSet.getBranch()));
            this.assertNonEmptyQuery(searcher, this.queryLastModified(changeSet.getDate()));
            TopDocs topDocs = searcher.search(this.queryBranch(changeSet.getRepName(), changeSet.getBranch()), 1);
            Assert.assertThat((Object)topDocs.scoreDocs.length, (Matcher)Matchers.is((Object)1));
            BranchDocInfo doc = BranchDocInfo.fromDocumentToBranchDocInfo((Document)searcher.doc(topDocs.scoreDocs[0].doc));
            Assert.assertThat((Object)doc.getBranch(), (Matcher)Matchers.is((Object)changeSet.getBranch()));
            Assert.assertThat((Object)doc.getLastModified(), (Matcher)Matchers.is((Object)changeSet.getDate()));
            Assert.assertThat((Object)doc.getLastChangeSetId(), (Matcher)Matchers.is((Object)changeSet.getId()));
            return null;
        });
    }

    @Test
    public void testIndexUpdatedBranches_removesBranch() throws Exception {
        this.branchIndexer.indexBranches((Iterable)ImmutableList.of((Object)new Branch("branchA", "a", BranchState.ACTIVE), (Object)new Branch("branchB", "b", BranchState.ACTIVE), (Object)new Branch("branchC", "c", BranchState.ACTIVE)), FisheyeTestUtil.mockChangeSetResolver(new ChangeSet[0]), new RepositoryStatus("rep1"));
        this.branchIndexer.indexBranches((Iterable)ImmutableList.of((Object)new Branch("branchA", "d", BranchState.ACTIVE)), FisheyeTestUtil.mockChangeSetResolver(new ChangeSet[0]), new RepositoryStatus("rep2"));
        this.branchIndexer.removeBranches("rep1", Collections.singleton("branchA"));
        this.crossRepoLuceneIndex.getConnection().withIndexSearcher((LuceneConnection.IndexConfig)CrossRepLuceneIndexes.METADATA, searcher -> {
            TopDocs branchesInRep1 = searcher.search(((BranchQueryBuilder)BranchQueryBuilder.newInstance().fromTheseRepos(Collections.singleton("rep1"))).build(), Integer.MAX_VALUE);
            Assert.assertThat((Object)Iterables.transform(Arrays.asList(branchesInRep1.scoreDocs), scoreDoc -> {
                try {
                    return BranchDocInfo.fromDocumentToBranchDocInfo((Document)searcher.doc(scoreDoc.doc)).getBranch();
                }
                catch (Exception e) {
                    Assert.fail((String)e.toString());
                    return null;
                }
            }), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"branchB", "branchC"}));
            this.assertNonEmptyQuery(searcher, this.queryBranch("rep2", "branchA"));
            return null;
        });
    }

    private void assertNonEmptyQuery(IndexSearcher searcher, Query query) throws IOException {
        TopDocs topDocs = searcher.search(query, 1);
        Assert.assertThat((String)("query " + query + " should be non empty"), (Object)topDocs.scoreDocs.length, (Matcher)Matchers.is((Object)1));
    }

    private Query queryBranch(String repName, String branchName) throws IOException {
        return BranchQueryBuilder.newInstance().withAnyStringInName((Iterable)ImmutableList.of((Object)branchName)).fromTheseRepos(Collections.singleton(repName)).build();
    }

    private Query queryLastModified(long lastModified) throws IOException {
        return BranchQueryBuilder.newInstance().withLastModified(Long.valueOf(lastModified), Long.valueOf(lastModified), true, true).build();
    }
}

