/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.fecru.search.index.model.DocInfo;
import com.atlassian.fecru.search.index.service.LuceneTestUtil;
import com.atlassian.fecru.search.index.service.TestDocInfoManager;
import com.cenqua.fisheye.crossrepo.BranchDoc;
import com.cenqua.fisheye.crossrepo.BranchDocInfo;
import com.cenqua.fisheye.crossrepo.BranchQueryBuilder;
import com.cenqua.fisheye.rep.BranchState;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BranchDocInfoTest {
    public static final String REP = "rep";
    private static final Function<BranchDocInfo, String> BRANCH_DOC_TO_NAME = BranchDocInfo::getBranch;
    private Directory dir;
    private TestDocInfoManager<BranchDocInfo> manager;

    @Before
    public void setUp() throws Exception {
        this.dir = new RAMDirectory();
        this.manager = LuceneTestUtil.newRAMDocInfoManager(this.dir);
    }

    @Test
    public void testUpdateDoc_deletesPrevious() throws Exception {
        BranchDocInfo docInfo1 = BranchDocInfo.fromBranchDoc((BranchDoc)new BranchDoc("test", "12345", System.currentTimeMillis(), "issue/branch", BranchState.ACTIVE, -1L, -1L));
        BranchDocInfo docInfo2 = BranchDocInfo.fromBranchDoc((BranchDoc)new BranchDoc("test", "12345", System.currentTimeMillis() + 1000000L, "issue/branch", BranchState.ACTIVE, -1L, -1L));
        this.manager.updateDoc((DocInfo)docInfo1);
        this.manager.updateDoc((DocInfo)docInfo1);
        this.manager.updateDoc((DocInfo)docInfo2);
        this.manager.commit();
        IndexReader reader = IndexReader.open((Directory)this.dir);
        Assert.assertEquals((long)1L, (long)reader.numDocs());
        Assert.assertEquals((long)2L, (long)reader.numDeletedDocs());
    }

    @Test
    public void testUpdateDoc_storesLastChangeSetId() throws Exception {
        BranchDocInfo docInfo = BranchDocInfo.fromBranchDoc((BranchDoc)new BranchDoc("test", "12345", System.currentTimeMillis(), "issue/branch", BranchState.ACTIVE, -1L, -1L));
        this.manager.updateDoc((DocInfo)docInfo);
        this.manager.commit();
        BranchDocInfo doc = (BranchDocInfo)this.manager.findDoc(((BranchQueryBuilder)BranchQueryBuilder.newInstance().byKeyTerm(docInfo.getKeyTerm())).build(), BranchDocInfo.CONVERTER);
        Assert.assertThat((Object)"12345", (Matcher)Matchers.is((Object)doc.getLastChangeSetId()));
    }

    @Test
    public void testSupportsBranchesWithNullCsid() throws Exception {
        BranchDocInfo docInfo = BranchDocInfo.fromBranchDoc((BranchDoc)new BranchDoc(REP, null, 0L, "branch", BranchState.ACTIVE, -1L, -1L));
        this.manager.updateDoc((DocInfo)docInfo);
        this.manager.commit();
        BranchDocInfo doc = (BranchDocInfo)this.manager.findDoc(((BranchQueryBuilder)BranchQueryBuilder.newInstance().byKeyTerm(docInfo.getKeyTerm())).build(), BranchDocInfo.CONVERTER);
        Assert.assertThat((Object)doc.getLastChangeSetId(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testQueryByUpdateTime() throws Exception {
        BranchDocInfo doc1 = BranchDocInfo.fromBranchDoc((BranchDoc)new BranchDoc(REP, "1", 0L, "branch1", BranchState.ACTIVE, 200L, 5L));
        BranchDocInfo doc2 = BranchDocInfo.fromBranchDoc((BranchDoc)new BranchDoc(REP, "1", 0L, "branch2", BranchState.ACTIVE, 100L, 15L));
        BranchDocInfo doc3 = BranchDocInfo.fromBranchDoc((BranchDoc)new BranchDoc(REP, "1", 0L, "branch3", BranchState.ACTIVE, 300L, 10L));
        this.manager.updateDoc((DocInfo)doc1);
        this.manager.updateDoc((DocInfo)doc2);
        this.manager.updateDoc((DocInfo)doc3);
        this.manager.commit();
        ImmutableList docs = ImmutableList.copyOf((Collection)this.manager.findDocs(BranchQueryBuilder.newInstance().withRepo(REP).updatedBetween(50L, 150L).build(), BranchDocInfo.CONVERTER, 10));
        Assert.assertThat((Object)docs, (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)((BranchDocInfo)docs.get(0)).getBranch(), (Matcher)Matchers.equalTo((Object)"branch2"));
        Assert.assertThat((Object)((BranchDocInfo)docs.get(0)).getFirstIndexedTimestamp(), (Matcher)Matchers.equalTo((Object)15L));
        Assert.assertThat((Object)((BranchDocInfo)docs.get(0)).getBranchState(), (Matcher)Matchers.equalTo((Object)BranchState.ACTIVE.getValue()));
    }

    @Test
    public void testQueryBuilderOmitsRemoved() throws Exception {
        BranchDocInfo doc1 = BranchDocInfo.fromBranchDoc((BranchDoc)new BranchDoc(REP, "1", 0L, "branch1", BranchState.REMOVED, 200L, 5L));
        BranchDocInfo doc2 = BranchDocInfo.fromBranchDoc((BranchDoc)new BranchDoc(REP, "1", 0L, "branch2", BranchState.ACTIVE, 100L, 15L));
        BranchDocInfo doc3 = BranchDocInfo.fromBranchDoc((BranchDoc)new BranchDoc(REP, "1", 0L, "branch3", BranchState.CLOSED, 100L, 15L));
        BranchDocInfo doc4 = BranchDocInfo.fromBranchDoc((BranchDoc)new BranchDoc(REP, "1", 0L, "branch4", BranchState.INACTIVE, 100L, 15L));
        this.manager.updateDoc((DocInfo)doc1);
        this.manager.updateDoc((DocInfo)doc2);
        this.manager.updateDoc((DocInfo)doc3);
        this.manager.updateDoc((DocInfo)doc4);
        this.manager.commit();
        ImmutableList active = ImmutableList.copyOf((Collection)this.manager.findDocs(BranchQueryBuilder.newInstance().withRepo(REP).build(), BranchDocInfo.CONVERTER, 10));
        ImmutableList all = ImmutableList.copyOf((Collection)this.manager.findDocs(BranchQueryBuilder.newInstance().inAnyState().withRepo(REP).build(), BranchDocInfo.CONVERTER, 10));
        Assert.assertThat((Object)Iterables.transform((Iterable)active, BRANCH_DOC_TO_NAME), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"branch2", "branch3", "branch4"}));
        Assert.assertThat((Object)Iterables.transform((Iterable)all, BRANCH_DOC_TO_NAME), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"branch1", "branch2", "branch3", "branch4"}));
    }
}

