/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.fecru.search.index.model.DocInfo;
import com.atlassian.fecru.search.index.service.LuceneTestUtil;
import com.atlassian.fecru.search.index.service.TestDocInfoManager;
import com.cenqua.fisheye.crossrepo.AuthorDocInfo;
import com.cenqua.fisheye.crossrepo.AuthorQueryBuilder;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AuthorDocInfoTest {
    TestDocInfoManager<AuthorDocInfo> dao;

    @Before
    public void setUp() throws Exception {
        this.dao = LuceneTestUtil.newRAMDocInfoManager();
        this.dao.addDoc((DocInfo)new AuthorDocInfo("piotr", "repoA"));
        this.dao.addDoc((DocInfo)new AuthorDocInfo("lukasz", "repoA"));
        this.dao.addDoc((DocInfo)new AuthorDocInfo("piotr", "repoB"));
        this.dao.commit();
    }

    @Test
    public void testIndexAuthor() throws Exception {
        Assert.assertThat((String)"3 authors in total", (Object)this.dao.countDocs(AuthorQueryBuilder.newAuthorCrossRepoQueryBuilder().build()), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((String)"2 authors of piotr", (Object)this.dao.countDocs(AuthorQueryBuilder.newAuthorCrossRepoQueryBuilder().queryByAuthor("piotr").build()), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((String)"2 authors of piotr (even when searched by substring)", (Object)this.dao.countDocs(AuthorQueryBuilder.newAuthorCrossRepoQueryBuilder().queryByAuthor("otr").build()), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((String)"2 authors of piotr (even when by mixed case substring)", (Object)this.dao.countDocs(AuthorQueryBuilder.newAuthorCrossRepoQueryBuilder().queryByAuthor("iOtr").build()), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((String)"1 author of lukasz", (Object)this.dao.countDocs(AuthorQueryBuilder.newAuthorCrossRepoQueryBuilder().queryByAuthor("lukasz").build()), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((String)"1 author of lukasz (even when by mixed case substring)", (Object)this.dao.countDocs(AuthorQueryBuilder.newAuthorCrossRepoQueryBuilder().queryByAuthor("KaSZ").build()), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testKeyTerm() throws Exception {
        AuthorDocInfo doc = (AuthorDocInfo)this.dao.findDoc((Query)new TermQuery(new AuthorDocInfo("piotr", "repoA").getKeyTerm()), AuthorDocInfo.AUTHOR_CONVERTER);
        Assert.assertThat((String)"author document found", (Object)doc, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"author matches key term", (Object)doc.getAuthor(), (Matcher)Matchers.is((Object)"piotr"));
        Assert.assertThat((String)"repository name matches key term", (Object)doc.getRepository(), (Matcher)Matchers.is((Object)"repoA"));
        Assert.assertThat((String)"key term is case sensitive, no result expected (wrong author case)", (Object)this.dao.countDocs((Query)new TermQuery(new AuthorDocInfo("PioTR", "repoA").getKeyTerm())), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((String)"key term is case sensitive, no result expected (wrong repo case)", (Object)this.dao.countDocs((Query)new TermQuery(new AuthorDocInfo("piotr", "repoa").getKeyTerm())), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testAuthorConverter() throws Exception {
        AuthorDocInfo lukaszesDoc = (AuthorDocInfo)this.dao.findDoc(AuthorQueryBuilder.newAuthorCrossRepoQueryBuilder().queryByAuthor("KaSZ").build(), AuthorDocInfo.AUTHOR_CONVERTER);
        Assert.assertThat((String)"the only lukasz'es document found", (Object)lukaszesDoc, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"author name returned in original case", (Object)lukaszesDoc.getAuthor(), (Matcher)Matchers.is((Object)"lukasz"));
        Assert.assertThat((String)"repository name returned", (Object)lukaszesDoc.getRepository(), (Matcher)Matchers.is((Object)"repoA"));
    }
}

