/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.config.SyntaxDefinitions;
import com.cenqua.fisheye.syntax.SyntaxDefinition;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.cenqua.fisheye.util.TestUtil;
import java.io.File;
import java.util.LinkedList;
import junit.framework.TestCase;

public class SyntaxDefinitionsTest
extends TestCase {
    private SyntaxDefinitions sds;

    protected void setUp() throws Exception {
        File primaryDir = new File(FisheyeTestEnv.WORKSPACE_DIR, "etc/dist/syntax");
        File secondaryDir = FisheyeTestUtil.createTempDir("syntax");
        TestUtil.writeToFile(new File(secondaryDir, "filename.map"), "**/*.url url.def\n**/*.x1 x1.def\n**/*.java x1.def\n");
        TestUtil.writeToFile(new File(secondaryDir, "x1.def"), "syntaxdef x1 {/.*/m : { region {findlinks=true;}}}");
        LinkedList<File> dirs = new LinkedList<File>();
        dirs.add(primaryDir);
        dirs.add(secondaryDir);
        this.sds = new SyntaxDefinitions(dirs);
    }

    public void testResolutionOrder() {
        SyntaxDefinition x1 = this.sds.getByFileName("x1.def");
        SyntaxDefinitionsTest.assertNotNull((Object)x1);
        SyntaxDefinitionsTest.assertEquals((String)"x1", (String)x1.getName());
        SyntaxDefinition forDotJava = this.sds.getSyntaxDefinitionForFile("Foo.java");
        SyntaxDefinitionsTest.assertNotNull((Object)forDotJava);
        SyntaxDefinitionsTest.assertEquals((String)"java", (String)forDotJava.getName());
    }
}

