/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.cenqua.fisheye.config.ParseUtil;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.WebServerType;
import junit.framework.TestCase;
import org.apache.xmlbeans.XmlException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class SiteUrlTest
extends TestCase {
    public void testFallbackUrl() throws Exception {
        String lh = RootConfig.guessLocalhost();
        SiteUrlTest.assertSiteUrlGuess("http://" + lh, "<web-server><http bind=':80'/></web-server>");
        SiteUrlTest.assertSiteUrlGuess("http://" + lh + ":81", "<web-server><http bind=':81'/></web-server>");
        SiteUrlTest.assertSiteUrlGuess("http://foobar.com", "<web-server><http bind='foobar.com:80'/></web-server>");
        SiteUrlTest.assertSiteUrlGuess("http://foobar.com/foo", "<web-server context='foo'><http bind='foobar.com:80'/></web-server>");
        SiteUrlTest.assertSiteUrlGuess("http://" + lh, "<web-server></web-server>");
        SiteUrlTest.assertSiteUrlGuess("http://" + lh, "<web-server><ajp13 bind='100'/></web-server>");
    }

    private static void assertSiteUrlGuess(String expected, String xml) throws XmlException {
        WebServerType ws = ParseUtil.parseWebServer((String)xml);
        String url = RootConfig.guessSiteUrl((WebServerType)ws);
        SiteUrlTest.assertNotNull((Object)url);
        SiteUrlTest.assertEquals((String)expected, (String)url);
    }

    public void testLocalhostName() {
        String lh = RootConfig.guessLocalhost();
        Assert.assertThat((Object)lh, (Matcher)Matchers.not((Matcher)Matchers.equalToIgnoringCase((String)"localhost")));
    }
}

