/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.cenqua.fisheye.config.ParseUtil;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.RepSecurityType;
import com.cenqua.fisheye.config1.RepositoryType;
import org.junit.Assert;
import org.junit.Test;

public class RootConfigTest {
    @Test
    public void testZeroConf() throws Exception {
        ConfigDocument.Config config = this.upgradeDefaultsAndRepositories("<repository />", "<repository-defaults />");
        RepositoryType rep = config.getRepositoryArray(0);
        Assert.assertTrue((boolean)rep.getSecurity().getUseDefaults());
        this.assertNoPermissionsSet(rep.getSecurity());
    }

    @Test
    public void testUpgradeDefaults() throws Exception {
        ConfigDocument.Config config = this.upgradeDefaults("<repository-defaults><security allow-anon='false'><required-groups><group name='abba' /></required-groups></security></repository-defaults>");
        RepSecurityType defaultsSecurity = config.getRepositoryDefaults().getSecurity();
        Assert.assertFalse((boolean)defaultsSecurity.getAllowAnon());
        Assert.assertFalse((boolean)defaultsSecurity.getAllowLoggedIn());
        Assert.assertEquals((long)1L, (long)defaultsSecurity.getRequiredGroups().sizeOfGroupArray());
        Assert.assertEquals((Object)"abba", (Object)defaultsSecurity.getRequiredGroups().getGroupArray(0).getName());
    }

    @Test
    public void testUpgradeDefaultsAllowAnon() throws Exception {
        ConfigDocument.Config config = this.upgradeDefaults("<repository-defaults><security allow-anon='true'><required-groups /></security></repository-defaults>");
        RepSecurityType defaultsSecurity = config.getRepositoryDefaults().getSecurity();
        Assert.assertTrue((boolean)defaultsSecurity.getAllowAnon());
        Assert.assertFalse((boolean)defaultsSecurity.getAllowLoggedIn());
        Assert.assertEquals((long)0L, (long)defaultsSecurity.getRequiredGroups().sizeOfGroupArray());
    }

    @Test
    public void testUpgradeDefaultsNoGroupsSet() throws Exception {
        ConfigDocument.Config config = this.upgradeDefaults("<repository-defaults><security allow-anon='false'><required-groups /></security></repository-defaults>");
        RepSecurityType defaultsSecurity = config.getRepositoryDefaults().getSecurity();
        Assert.assertFalse((boolean)defaultsSecurity.getAllowAnon());
        Assert.assertTrue((boolean)defaultsSecurity.getAllowLoggedIn());
        Assert.assertEquals((long)0L, (long)defaultsSecurity.getRequiredGroups().sizeOfGroupArray());
    }

    @Test
    public void testUpgradeDefaultsReadGroupsSet() throws Exception {
        ConfigDocument.Config config = this.upgradeDefaults("<repository-defaults><security allow-anon='false'><required-groups><group name='aphex-twin' /></required-groups></security></repository-defaults>");
        RepSecurityType defaultsSecurity = config.getRepositoryDefaults().getSecurity();
        Assert.assertFalse((boolean)defaultsSecurity.getAllowAnon());
        Assert.assertFalse((boolean)defaultsSecurity.getAllowLoggedIn());
        Assert.assertEquals((long)1L, (long)defaultsSecurity.getRequiredGroups().sizeOfGroupArray());
        Assert.assertEquals((Object)"aphex-twin", (Object)defaultsSecurity.getRequiredGroups().getGroupArray(0).getName());
    }

    @Test
    public void testUpgradeRepositoryAnonymousWasDelegatedToDefaultsAndGroupsSetOnRepositoryAndDefaultIsAnonAllowed() throws Exception {
        ConfigDocument.Config config = this.upgradeDefaultsAndRepositories("<repository-defaults><security allow-anon='true' /></repository-defaults>", "<repository><security><required-groups><group name='queen' /></required-groups></security></repository>");
        this.assertUsingDefaults(config.getRepositoryArray(0));
    }

    @Test
    public void testUpgradeRepositoryAnonymousWasDelegatedToDefaultsAndGroupsSetOnRepositoryAndDefaultIsNotAnonAllowed() throws Exception {
        ConfigDocument.Config config = this.upgradeDefaultsAndRepositories("<repository-defaults><security allow-anon='false' /></repository-defaults>", "<repository><security><required-groups><group name='nofx' /></required-groups></security></repository>");
        RepSecurityType repSecurity = config.getRepositoryArray(0).getSecurity();
        Assert.assertFalse((boolean)repSecurity.getUseDefaults());
        Assert.assertFalse((boolean)repSecurity.getAllowAnon());
        Assert.assertFalse((boolean)repSecurity.getAllowLoggedIn());
        Assert.assertEquals((long)1L, (long)repSecurity.getRequiredGroups().sizeOfGroupArray());
        Assert.assertEquals((Object)"nofx", (Object)repSecurity.getRequiredGroups().getGroupArray(0).getName());
    }

    @Test
    public void testUpgradeRepositoryAnonymousWasDelegatedToDefaultsAndNoGroupsSetOnRepository() throws Exception {
        ConfigDocument.Config config = this.upgradeDefaultsAndRepositories("<repository-defaults />", "<repository><security><required-groups /></security></repository>");
        this.assertUsingDefaults(config.getRepositoryArray(0));
    }

    @Test
    public void testUpgradeRepositoryAnonymousWasNotDelegatedToDefaultsAndAnonSetToTrueOnRepository() throws Exception {
        ConfigDocument.Config config = this.upgradeDefaultsAndRepositories("<repository-defaults />", "<repository><security allow-anon='true'><required-groups /></security></repository>");
        RepSecurityType repSecurity = config.getRepositoryArray(0).getSecurity();
        Assert.assertFalse((boolean)repSecurity.getUseDefaults());
    }

    @Test
    public void testUpgradeRepositoryAnonymousWasNotDelegatedToDefaultsAndAnonSetToTrueOnRepositoryAndGroupsSetAndDefaultIsNotAllowAnon() throws Exception {
        ConfigDocument.Config config = this.upgradeDefaultsAndRepositories("<repository-defaults><security allow-anon='false' /></repository-defaults>", "<repository><security allow-anon='true'><required-groups><group name='inxs' /></required-groups></security></repository>");
        RepSecurityType repSecurity = config.getRepositoryArray(0).getSecurity();
        Assert.assertFalse((boolean)repSecurity.getUseDefaults());
    }

    @Test
    public void testUpgradeRepositoryAnonymousWasNotDelegatedToDefaultsAndAnonSetToFalseOnRepositoryAndGroupsSet() throws Exception {
        ConfigDocument.Config config = this.upgradeDefaultsAndRepositories("<repository-defaults><security allow-anon='true' /></repository-defaults>", "<repository><security allow-anon='false'><required-groups><group name='they-might-be-giants' /><group name='rage-against-the-machine' /></required-groups></security></repository>");
        RepSecurityType repSecurity = config.getRepositoryArray(0).getSecurity();
        Assert.assertFalse((boolean)repSecurity.getUseDefaults());
        Assert.assertFalse((boolean)repSecurity.getAllowAnon());
        Assert.assertFalse((boolean)repSecurity.getAllowLoggedIn());
        Assert.assertEquals((long)2L, (long)repSecurity.getRequiredGroups().sizeOfGroupArray());
        Assert.assertEquals((Object)"they-might-be-giants", (Object)repSecurity.getRequiredGroups().getGroupArray(0).getName());
        Assert.assertEquals((Object)"rage-against-the-machine", (Object)repSecurity.getRequiredGroups().getGroupArray(1).getName());
    }

    @Test
    public void testUpgradeRepositoryAnonymousWasNotDelegatedToDefaultsAndRepositoryNoGroupsWereSetAndAnonSetToTrueOnRepository() throws Exception {
        ConfigDocument.Config config = this.upgradeDefaultsAndRepositories("<repository-defaults />", "<repository><security allow-anon='true'><required-groups /></security></repository>");
        RepSecurityType repSecurity = config.getRepositoryArray(0).getSecurity();
        Assert.assertFalse((boolean)repSecurity.getUseDefaults());
    }

    @Test
    public void testUpgradeRepositoryAnonymousWasNotDelegatedToDefaultsAndNoGroupsWereSetOnRepositoryAndAnonSetToFalseOnRepositoryAndDefaultIsAnonAllowedAndDefaultGroupsSet() throws Exception {
        ConfigDocument.Config config = this.upgradeDefaultsAndRepositories("<repository-defaults><security allow-anon='true'><required-groups><group name='band-of-horses' /><group name='matisyahu' /></required-groups></security></repository-defaults>", "<repository><security allow-anon='false'><required-groups /></security></repository>");
        RepSecurityType repSecurity = config.getRepositoryArray(0).getSecurity();
        Assert.assertFalse((boolean)repSecurity.getUseDefaults());
        Assert.assertFalse((boolean)repSecurity.getAllowAnon());
        Assert.assertFalse((boolean)repSecurity.getAllowLoggedIn());
        Assert.assertEquals((long)2L, (long)repSecurity.getRequiredGroups().sizeOfGroupArray());
        Assert.assertEquals((Object)"band-of-horses", (Object)repSecurity.getRequiredGroups().getGroupArray(0).getName());
        Assert.assertEquals((Object)"matisyahu", (Object)repSecurity.getRequiredGroups().getGroupArray(1).getName());
    }

    @Test
    public void testUpgradeRepositoryAnonymousWasNotDelegatedToDefaultsAndNoGroupsWereSetOnRepositoryAndAnonSetToFalseOnRepositoryAndDefaultIsAnonAllowedAndNoDefaultGroupsSet() throws Exception {
        ConfigDocument.Config config = this.upgradeDefaultsAndRepositories("<repository-defaults><security allow-anon='true'><required-groups /></security></repository-defaults>", "<repository><security allow-anon='false'><required-groups /></security></repository>");
        RepSecurityType repSecurity = config.getRepositoryArray(0).getSecurity();
        Assert.assertFalse((boolean)repSecurity.getUseDefaults());
        Assert.assertFalse((boolean)repSecurity.getAllowAnon());
        Assert.assertTrue((boolean)repSecurity.getAllowLoggedIn());
        Assert.assertEquals((long)0L, (long)repSecurity.getRequiredGroups().sizeOfGroupArray());
    }

    @Test
    public void testUpgradeRepositoryAnonymousWasNotDelegatedToDefaultsAndNoGroupsWereSetOnRepositoryAndAnonSetToFalseOnBothRepositoryAndDefaults() throws Exception {
        ConfigDocument.Config config = this.upgradeDefaultsAndRepositories("<repository-defaults><security allow-anon='false'><required-groups><group name='men-at-work' /><group name='the-postal-service' /></required-groups></security></repository-defaults>", "<repository><security allow-anon='false'><required-groups /></security></repository>");
        RepSecurityType repSecurity = config.getRepositoryArray(0).getSecurity();
        Assert.assertTrue((boolean)repSecurity.getUseDefaults());
        this.assertNoPermissionsSet(repSecurity);
    }

    private void assertUsingDefaults(RepositoryType rep) {
        RepSecurityType security = rep.getSecurity();
        Assert.assertTrue((boolean)security.getUseDefaults());
        this.assertNoPermissionsSet(security);
    }

    private void assertNoPermissionsSet(RepSecurityType security) {
        Assert.assertFalse((boolean)security.getAllowAnon());
        Assert.assertFalse((boolean)security.getAllowLoggedIn());
        Assert.assertEquals((long)0L, (long)security.getRequiredGroups().sizeOfGroupArray());
    }

    private ConfigDocument.Config upgradeDefaults(String repositoryDefaultsXml) throws Exception {
        return this.upgradeDefaultsAndRepositories(repositoryDefaultsXml, "");
    }

    private ConfigDocument.Config upgradeDefaultsAndRepositories(String repositoryDefaultsXml, String repositoryXml) throws Exception {
        ConfigDocument.Config config = ParseUtil.parseAsConfig((String)(repositoryDefaultsXml + repositoryXml));
        new RootConfig().initConfigDefaults(config);
        new RootConfig().initConfigRepositories(config);
        return config;
    }
}

