/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RootConfig;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class RootConfigRule
extends TemporaryFolder {
    private RootConfig originalConfig;
    private RootConfig rootConfig;

    protected void before() throws Throwable {
        this.originalConfig = AppConfig.getsConfig();
        this.rootConfig = (RootConfig)Mockito.mock(RootConfig.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        AppConfig.resetConfig((RootConfig)this.rootConfig);
        super.before();
    }

    protected void after() {
        AppConfig.resetConfig((RootConfig)this.originalConfig);
        super.after();
    }

    public RootConfig loadRootConfigFile(String file) throws IOException, ConfigException {
        return this.loadRootConfigFile(this.getFile(file));
    }

    private RootConfig loadRootConfigFile(File file) throws IOException, ConfigException {
        this.rootConfig = new RootConfig();
        this.rootConfig.load(file);
        AppConfig.resetConfig((RootConfig)this.rootConfig);
        return this.rootConfig;
    }

    public RootConfig getRootConfig() {
        return this.rootConfig;
    }

    private File getFile(String testConfigFile) throws IOException {
        File file = this.newFile();
        URL resource = Resources.getResource((String)testConfigFile);
        Resources.copy((URL)resource, (OutputStream)new FileOutputStream(file));
        return file;
    }
}

