/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.license.LicenseHolder;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.support.ThreadDumpHelper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RepositoryRunPermitsTest {
    RootConfig.RepositoryRunPermits permits;

    @Before
    public void setUp() {
        this.permits = new RootConfig.RepositoryRunPermits(0);
    }

    @Test(expected=LicensePolicyException.class)
    public void testNoPermits() throws LicensePolicyException {
        this.permits.obtain("repo1");
    }

    @Test
    public void testSimple() throws LicensePolicyException {
        this.permits.setNumPermits(1);
        this.permits.obtain("repo1");
        this.permits.obtain("repo1");
        try {
            this.permits.obtain("repo2");
            Assert.fail((String)"Not expecting to get a permit");
        }
        catch (LicensePolicyException licensePolicyException) {
            // empty catch block
        }
        this.permits.release("repo2");
        this.permits.release("repo1");
        this.permits.obtain("repo2");
    }

    @Test
    public void testUnrestricted() throws LicensePolicyException {
        this.permits.setNumPermits(-1);
        for (int i = 0; i < 1000; ++i) {
            this.permits.obtain("repo" + i);
        }
    }

    @Test
    public void testStarterLicense() throws LicensePolicyException {
        LicenseInfo licenseInfo = new LicenseInfo(LicenseHolder.makeFishEyeOnlyLicense((String)"AAABMQ0ODAoPeNpdkFFLwzAUhd/zKwK+KOhowwZaCChrhMHspK0++XKtdzbQpiFJx/rvTW07ayEvy\nbk537nnKi9bmqGmbE3DIGIsYiEVWU5ZEDyQGG1hpHayUfxZ2lJ0SK/DgBZNXUvn0Fiq0VCDurHSN\naa7pZu/m0R78xHRzIHxo3QvC1QWSdLWn2gOxzfr//MwIFuD0CNicMh77p0/bE22jXJQuARq5JOJO\nEOtK5w08QKy4nYQH3EQVz4eESeo2l9bfoTKY48+P3a4mvDbyw59hkn1nvKE3JkWSTUEfvcjvQ0jH\nqYcKlAFirOWphsTh8GYeMlIZ1XwDTmYb1DSwr8+l/VkIuH3oS9/fNjFfL+L5y8zdqsq6bfArwt6n\nMk7jUNx+VOai5S8tqYoweKy5B/6o7FHMC0CFQCFOtZh47HhjSXWexBOhZJ+ZPgOFAIUGkrapw088\n2xL1hJux1fDHJ2LMXw=X02fb"));
        this.permits.setNumPermits(licenseInfo.getMaxRepositories());
        for (int i = 0; i < licenseInfo.getMaxRepositories(); ++i) {
            this.permits.obtain("repo" + i);
        }
        try {
            this.permits.obtain("overlimit");
            Assert.fail((String)"Wasn't expecting to obtain an extra permit");
        }
        catch (LicensePolicyException licensePolicyException) {
            // empty catch block
        }
    }

    @Test
    public void testMultiThreaded() throws Exception {
        int numThreads = 5;
        int iterationsPerThread = 1000;
        this.permits.setNumPermits(5);
        ExecutorService pool = Executors.newFixedThreadPool(5);
        AtomicInteger cyclesPerformed = new AtomicInteger();
        for (int i = 0; i < 5; ++i) {
            pool.submit(() -> {
                try {
                    for (int i1 = 0; i1 < 1000; ++i1) {
                        this.permits.obtain(Thread.currentThread().getName());
                        Thread.sleep((int)(20.0 * Math.random()));
                        this.permits.release(Thread.currentThread().getName());
                        cyclesPerformed.incrementAndGet();
                    }
                }
                catch (LicensePolicyException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
        }
        pool.shutdown();
        if (!pool.awaitTermination(5L, TimeUnit.MINUTES)) {
            StringBuilder threaddump = new StringBuilder();
            ThreadDumpHelper.getThreadDump((Appendable)threaddump);
            Assert.fail((String)("deadlocked?\n" + threaddump));
        }
        Assert.assertEquals((String)"Wrong number of cycles performed", (long)5000L, (long)cyclesPerformed.get());
    }
}

