/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.cenqua.fisheye.config.ParseUtil;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.RepSecurityType;
import com.cenqua.fisheye.config1.RepositoryDefaultsType;
import com.cenqua.fisheye.config1.RepositoryType;
import junit.framework.TestCase;
import org.apache.xmlbeans.XmlException;

public class ParseUtilTest
extends TestCase {
    private static String FILE_ENTITY = "<!DOCTYPE soapenv:Envelope [<!ENTITY readme SYSTEM \"/etc/passwd\">]><config><license><crucible>&readme;</crucible></license></config>";

    public void testFragmentParsing() throws Exception {
        this.subtestRepository("    <repository name='foo'>\n        <linker/>\n        <allow/>\n        <tarball enabled=\"false\"/>\n        <security allow-anon=\"true\"/>\n    </repository>");
        this.subtestRepDefaults("    <repository-defaults>\n        <linker/>\n        <allow/>\n        <tarball enabled=\"false\"/>\n        <security allow-anon=\"true\"/>\n    </repository-defaults>");
        this.subtestRepDefaults("    <c:repository-defaults xmlns:c='http://www.cenqua.com/fisheye/config-1'>\n        <linker/>\n        <allow/>\n        <tarball enabled=\"false\"/>\n        <security allow-anon=\"true\"/>\n    </c:repository-defaults>");
        this.subtestRepDefaults("    <c:repository-defaults xmlns:c='http://www.cenqua.com/fisheye/config-1'>\n        <c:linker/>\n        <c:allow/>\n        <c:tarball enabled=\"false\"/>\n        <c:security allow-anon=\"true\"/>\n    </c:repository-defaults>");
        RepSecurityType sec = ParseUtil.parseRepositorySecurity((String)"<security allow-anon='false'>  <required-groups><group name='foo'/></required-groups></security>");
        ParseUtilTest.assertFalse((boolean)sec.getAllowAnon());
        ParseUtilTest.assertTrue((boolean)sec.isSetRequiredGroups());
        ParseUtilTest.assertEquals((int)1, (int)sec.getRequiredGroups().sizeOfGroupArray());
        ParseUtilTest.assertEquals((String)"foo", (String)sec.getRequiredGroups().getGroupArray(0).getName());
    }

    public void testConfigXMLIsSafeFromXXEAttack() throws XmlException {
        ConfigDocument.Config config = ParseUtil.parseConfig((String)FILE_ENTITY);
        ParseUtilTest.assertEquals((String)"", (String)config.getLicense().getCrucible());
    }

    private void subtestRepository(String xml) throws XmlException {
        RepositoryType rd = ParseUtil.parseRepository((String)xml);
        ParseUtilTest.assertEquals((String)"foo", (String)rd.getName());
        ParseUtilTest.assertFalse((boolean)rd.getTarball().getEnabled());
        ParseUtilTest.assertTrue((boolean)rd.getSecurity().getAllowAnon());
    }

    private void subtestRepDefaults(String xml) throws XmlException {
        RepositoryDefaultsType rd = ParseUtil.parseRepositoryDefaults((String)xml);
        ParseUtilTest.assertFalse((boolean)rd.getTarball().getEnabled());
        ParseUtilTest.assertTrue((boolean)rd.getSecurity().getAllowAnon());
    }
}

