/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.atlassian.fecru.matcher.FileMatchers;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.config.OldOsgiCacheDirectoryCleanerUpgradeTask;
import com.cenqua.fisheye.io.IOHelper;
import java.io.File;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OldOsgiCacheDirectoryCleanerUpgradeTaskTest {
    private File baseDir;
    private File appConfigInstanceHomeOrig;
    private OldOsgiCacheDirectoryCleanerUpgradeTask cleaner;

    @Before
    public void setUp() throws Exception {
        this.baseDir = FisheyeTestUtil.createTempDir("OldOsgiCacheDirectoryCleanerTest");
        this.appConfigInstanceHomeOrig = AppConfig.getInstanceDir();
        AppConfig.overrideAppHome((File)AppConfig.getAppHome(), (File)this.baseDir);
        this.cleaner = new OldOsgiCacheDirectoryCleanerUpgradeTask();
    }

    @After
    public void tearDown() throws Exception {
        AppConfig.overrideAppHome((File)AppConfig.getAppHome(), (File)this.appConfigInstanceHomeOrig);
        FisheyeTestUtil.deleteDir(this.baseDir);
    }

    @Test
    public void testRun() throws Exception {
        File oldOsgiFolder = new File(this.baseDir, "/cache/plugins/osgi-cache");
        Assert.assertThat((String)"failed to create fake old osgi-cache folder", (Object)IOHelper.mkdirs((File)oldOsgiFolder), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        File someSubdir = new File(oldOsgiFolder, "/dir/subdir");
        Assert.assertThat((String)"failed to create fake old osgi-cache subfolders", (Object)IOHelper.mkdirs((File)someSubdir), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        File someFile = new File(someSubdir, "fu.bar");
        Assert.assertThat((String)"failed to create fake file", (Object)someFile.createNewFile(), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        someFile.deleteOnExit();
        this.cleaner.run();
        Assert.assertThat((String)"osgi folder should be deleted after the test", (Object)oldOsgiFolder, (Matcher)CoreMatchers.not(FileMatchers.exists()));
    }
}

