/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.EntityLink;
import com.cenqua.fisheye.config.AdminConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.LicenseType;
import com.cenqua.fisheye.syntax.DefaultLinkerService;
import com.cenqua.fisheye.syntax.Linker;
import com.cenqua.fisheye.syntax.LinkerFactory;
import com.cenqua.fisheye.syntax.LinkerService;
import com.cenqua.fisheye.syntax.SyntaxDefinition;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.LinkedList;
import org.junit.Assert;
import org.mockito.Mockito;

public class ConfigMockery {
    public static RootConfig mockRootConfig() {
        RootConfig config = (RootConfig)Mockito.mock(RootConfig.class);
        ConfigDocument.Config docConfig = (ConfigDocument.Config)Mockito.mock(ConfigDocument.Config.class);
        AdminConfig adminConfig = (AdminConfig)Mockito.mock(AdminConfig.class);
        UserManager userManager = (UserManager)Mockito.mock(UserManager.class);
        LicenseType licenseConfig = (LicenseType)Mockito.mock(LicenseType.class);
        Linker linker = (Linker)Mockito.mock(Linker.class);
        Mockito.when((Object)config.getConfig()).thenReturn((Object)docConfig);
        Mockito.when((Object)config.getAdminConfig()).thenReturn((Object)adminConfig);
        Mockito.when((Object)config.getUserManager()).thenReturn((Object)userManager);
        Mockito.when((Object)docConfig.getLicense()).thenReturn((Object)licenseConfig);
        Mockito.when((Object)config.getSiteURL()).thenReturn((Object)"http://localhost");
        Mockito.when((Object)config.getContextPath()).thenReturn((Object)"/foo");
        Mockito.when((Object)config.getDefaultLinker()).thenReturn((Object)linker);
        Mockito.when((Object)config.isFishEye()).thenReturn((Object)true);
        Mockito.when((Object)config.isCrucible()).thenReturn((Object)true);
        return config;
    }

    public static DefaultLinkerService createBugzillaLinkerService() {
        final Linker linker = new Linker();
        try {
            ConfigMockery.loadSynDef(linker, new FileInputStream(new File(FisheyeTestEnv.WORKSPACE_DIR, "etc/dist/syntax/url.def")));
            ConfigMockery.loadSynDef(linker, ConfigMockery.class.getResourceAsStream("bugzilla.def"));
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        DefaultLinkerService defaultLinkerService = new DefaultLinkerService(){

            public Linker getLinker(String repositoryName, String projectKey, LinkerService.Type ... linkers) {
                return linker;
            }
        };
        return defaultLinkerService;
    }

    public static DefaultLinkerService createJIRALinkerService() throws URISyntaxException, FileNotFoundException {
        EntityLink fakeJira = (EntityLink)Mockito.mock(EntityLink.class);
        ApplicationLink fakeAppLink = (ApplicationLink)Mockito.mock(ApplicationLink.class);
        String jiraURL = "http://fake/jira";
        Mockito.when((Object)fakeAppLink.getDisplayUrl()).thenReturn((Object)new URI(jiraURL));
        Mockito.when((Object)fakeJira.getKey()).thenReturn((Object)"JRA");
        Mockito.when((Object)fakeJira.getApplicationLink()).thenReturn((Object)fakeAppLink);
        final Linker jiraLinker = LinkerFactory.generateJiraSyntaxDef((Collection)Lists.newArrayList((Object[])new EntityLink[]{fakeJira}));
        ConfigMockery.loadSynDef(jiraLinker, new FileInputStream(new File(FisheyeTestEnv.WORKSPACE_DIR, "etc/dist/syntax/url.def")));
        DefaultLinkerService defaultLinkerService = new DefaultLinkerService(){

            public Linker getLinker(String repositoryName, String projectKey, LinkerService.Type ... linkers) {
                return jiraLinker;
            }
        };
        return defaultLinkerService;
    }

    private static void loadSynDef(Linker linker, InputStream asStream) throws FileNotFoundException {
        LinkedList errors = new LinkedList();
        linker.addHighlighter(SyntaxDefinition.parse((Reader)new InputStreamReader(asStream), errors));
        Assert.assertEquals((String)("Error parsing syntax def: " + errors), (long)0L, (long)errors.size());
    }
}

