/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.cenqua.fisheye.config.Bind;
import java.net.InetAddress;
import java.net.UnknownHostException;
import junit.framework.Assert;
import org.junit.Test;

public final class BindTest {
    @Test
    public void testNoBind() {
        Bind bind = Bind.parse((String)"", (String)"host", (int)80);
        Assert.assertEquals((String)"host", (String)bind.getHost());
        Assert.assertEquals((int)80, (int)bind.getPort());
    }

    @Test
    public void testInvalidBind() {
        Bind bind = Bind.parse((String)"invalidBind.invalid:42", (String)"host", (int)80);
        Assert.assertEquals((String)"host", (String)bind.getHost());
        Assert.assertEquals((int)80, (int)bind.getPort());
    }

    @Test
    public void testJustPort() {
        Bind bind = Bind.parse((String)":42", (String)"host", (int)80);
        Assert.assertEquals((String)"host", (String)bind.getHost());
        Assert.assertEquals((int)42, (int)bind.getPort());
    }

    @Test
    public void testHostAndPort() throws UnknownHostException {
        String expectedHost = InetAddress.getByName("192.168.1.1").getHostAddress();
        Bind bind = Bind.parse((String)"192.168.1.1:42", (String)"host", (int)80);
        Assert.assertEquals((String)expectedHost, (String)bind.getHost());
        Assert.assertEquals((int)42, (int)bind.getPort());
        Bind bind2 = Bind.parse((String)"localhost:42", (String)"host", (int)80);
        Assert.assertEquals((String)"localhost", (String)bind2.getHost());
        Assert.assertEquals((int)42, (int)bind2.getPort());
    }
}

