/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.cenqua.fisheye.config.AdminConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.google.common.base.Throwables;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.AdditionalMatchers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class AdminConfigTest {
    public static final String TEST_PASSWORD_RAW = "test_password";
    public static final String TEST_PASSWORD_MD5 = "16ec1ebb01fe02ded9b7d5447d3dfc65";
    public static final String TEST_PASSWORD_SALTED = "{PKCS5S2}PPtOsEps4BH4s14PTLaSqbID7wE63hGHjIds6O4eEy5FDstNBxP+zxjy5fYBW4Yb";
    public static final String BAD_PASSWORD_RAW = "bad_password";
    public static final String HASH_PREFIX = "{PKCS5S2}";
    private AdminConfig config;
    @Mock
    private ConfigDocument.Config configFile;
    @Mock
    RootConfig rootConfig;

    @Before
    public void setup() {
        Mockito.when((Object)this.rootConfig.getConfig()).thenReturn((Object)this.configFile);
        this.config = new AdminConfig(this.rootConfig);
        this.mockAdminHashIsGetSet();
    }

    private void mockAdminHashIsGetSet() {
        ((ConfigDocument.Config)Mockito.doAnswer(invocation -> {
            String hash = (String)invocation.getArguments()[0];
            Mockito.when((Object)this.configFile.getAdminHash()).thenReturn((Object)hash);
            return null;
        }).when((Object)this.configFile)).setAdminHash(Matchers.anyString());
        ((ConfigDocument.Config)Mockito.doAnswer(invocation -> this.configFile.getAdminHash() != null).when((Object)this.configFile)).isSetAdminHash();
    }

    @Test
    public void testVerifyAdminPasswordStoredAsMD5() throws Exception {
        this.configFile.setAdminHash(TEST_PASSWORD_MD5);
        boolean isValidPassword = this.config.verifyAdminPassword(TEST_PASSWORD_RAW);
        Assert.assertThat((Object)isValidPassword, (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testVerifyAdminPasswordStoredAsMD5_shouldFailIfBadPassword() throws Exception {
        this.configFile.setAdminHash(TEST_PASSWORD_MD5);
        boolean isValidPassword = this.config.verifyAdminPassword(BAD_PASSWORD_RAW);
        Assert.assertThat((Object)isValidPassword, (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void testVerifyAdminPasswordSalted() {
        this.configFile.setAdminHash(TEST_PASSWORD_SALTED);
        boolean isValidPassword = this.config.verifyAdminPassword(TEST_PASSWORD_RAW);
        Assert.assertThat((Object)isValidPassword, (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testVerifyAdminPasswordSalted_shouldFailIfBadPassword() {
        this.configFile.setAdminHash(TEST_PASSWORD_SALTED);
        boolean isValidPassword = this.config.verifyAdminPassword(BAD_PASSWORD_RAW);
        Assert.assertThat((Object)isValidPassword, (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void testVerifyAdminPasswordSalted_shouldFailIfBadPrefix() {
        this.configFile.setAdminHash("{SHA512}PPtOsEps4BH4s14PTLaSqbID7wE63hGHjIds6O4eEy5FDstNBxP+zxjy5fYBW4Yb");
        boolean isValidPassword = this.config.verifyAdminPassword(TEST_PASSWORD_RAW);
        Assert.assertThat((Object)isValidPassword, (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void testUpdateAdminPassword() {
        this.config.setAdminPassword(TEST_PASSWORD_RAW);
        Assert.assertTrue((boolean)this.config.verifyAdminPassword(TEST_PASSWORD_RAW));
        Assert.assertThat((Object)this.configFile.getAdminHash(), (Matcher)CoreMatchers.startsWith((String)HASH_PREFIX));
    }

    @Test
    public void testChangePasswordWhenHashWasMD5() {
        this.configFile.setAdminHash(TEST_PASSWORD_MD5);
        boolean result = this.config.changeAdminPassword(TEST_PASSWORD_RAW, "changed password");
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)this.config.verifyAdminPassword("changed password"), (Matcher)CoreMatchers.equalTo((Object)true));
        ((ConfigDocument.Config)Mockito.verify((Object)this.configFile, (VerificationMode)Mockito.times((int)2))).setAdminHash(Matchers.anyString());
    }

    @Test
    public void testChangePasswordWhenHashWasSalted() {
        this.configFile.setAdminHash(TEST_PASSWORD_SALTED);
        boolean result = this.config.changeAdminPassword(TEST_PASSWORD_RAW, "changed password");
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)this.config.verifyAdminPassword("changed password"), (Matcher)CoreMatchers.equalTo((Object)true));
        ((ConfigDocument.Config)Mockito.verify((Object)this.configFile, (VerificationMode)Mockito.times((int)2))).setAdminHash(Matchers.anyString());
    }

    @Test
    public void testPasswordIsActuallySalted() {
        this.config.setAdminPassword(TEST_PASSWORD_RAW);
        String hash1 = this.configFile.getAdminHash();
        this.config.setAdminPassword(TEST_PASSWORD_RAW);
        String hash2 = this.configFile.getAdminHash();
        Assert.assertThat((Object)hash1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)hash2)));
    }

    @Test
    public void testVerifyAndUpgrade_shouldNotUpdateIfWasntMD5() {
        String saltedHash = TEST_PASSWORD_SALTED;
        this.configFile.setAdminHash(TEST_PASSWORD_SALTED);
        boolean isValidPassword = this.config.verifyAdminPassword(TEST_PASSWORD_RAW);
        Assert.assertThat((Object)isValidPassword, (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((String)"There was no need for upgrading password", (Object)this.configFile.getAdminHash(), (Matcher)CoreMatchers.equalTo((Object)TEST_PASSWORD_SALTED));
    }

    @Test
    public void testVerifyAndUpgrade_shouldUpdateIfWasMD5() {
        this.configFile.setAdminHash(TEST_PASSWORD_MD5);
        boolean isValidPassword = this.config.verifyAdminPassword(TEST_PASSWORD_RAW);
        String hashAfterSuccessfulVerify = this.configFile.getAdminHash();
        boolean isValidPasswordAgain = this.config.verifyAdminPassword(TEST_PASSWORD_RAW);
        Assert.assertThat((Object)isValidPassword, (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)hashAfterSuccessfulVerify, (Matcher)CoreMatchers.startsWith((String)HASH_PREFIX));
        Assert.assertThat((Object)isValidPasswordAgain, (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testVerifyAndUpgrade_shouldUpgradeOnlyOnceForManyThreads() throws InterruptedException, ExecutionException {
        this.configFile.setAdminHash(TEST_PASSWORD_MD5);
        int numThreads = 100;
        CountDownLatch startSignal = new CountDownLatch(100);
        List<Callable<Boolean>> tasks = Collections.nCopies(100, () -> {
            startSignal.countDown();
            startSignal.await();
            return this.config.verifyAdminPassword(TEST_PASSWORD_RAW);
        });
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        List<Future<Boolean>> results = executorService.invokeAll(tasks, 30L, TimeUnit.SECONDS);
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)100));
        for (Future<Boolean> result : results) {
            Assert.assertThat((Object)result.get(), (Matcher)CoreMatchers.equalTo((Object)true));
        }
        ((ConfigDocument.Config)Mockito.verify((Object)this.configFile, (VerificationMode)Mockito.times((int)1))).setAdminHash((String)Matchers.eq((Object)TEST_PASSWORD_MD5));
        ((ConfigDocument.Config)Mockito.verify((Object)this.configFile, (VerificationMode)Mockito.times((int)1))).setAdminHash((String)AdditionalMatchers.not((Object)Matchers.eq((Object)TEST_PASSWORD_MD5)));
        ((ConfigDocument.Config)Mockito.verify((Object)this.configFile, (VerificationMode)Mockito.atLeast((int)101))).getAdminHash();
        ((ConfigDocument.Config)Mockito.verify((Object)this.configFile, (VerificationMode)Mockito.atMost((int)200))).getAdminHash();
    }

    @Test
    public void testChangePassword_shouldProceedOnlyOnce() throws InterruptedException, ExecutionException {
        this.configFile.setAdminHash(TEST_PASSWORD_MD5);
        int numThreads = 100;
        CountDownLatch startSignal = new CountDownLatch(100);
        List<Callable<Boolean>> tasks = Collections.nCopies(100, () -> {
            startSignal.countDown();
            startSignal.await();
            return this.config.changeAdminPassword(TEST_PASSWORD_RAW, "changed password");
        });
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        List<Future<Boolean>> results = executorService.invokeAll(tasks, 30L, TimeUnit.SECONDS);
        Stream<Future> successResults = results.stream().filter(a -> {
            try {
                return (Boolean)a.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Throwables.propagate((Throwable)e);
                return false;
            }
        });
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)100));
        Assert.assertThat((String)"only one thread succeeded", (Object)successResults.count(), (Matcher)CoreMatchers.equalTo((Object)1L));
        Assert.assertThat((Object)this.config.verifyAdminPassword("changed password"), (Matcher)CoreMatchers.equalTo((Object)true));
        ((ConfigDocument.Config)Mockito.verify((Object)this.configFile, (VerificationMode)Mockito.times((int)1))).setAdminHash(Matchers.startsWith((String)HASH_PREFIX));
        ((ConfigDocument.Config)Mockito.verify((Object)this.configFile, (VerificationMode)Mockito.times((int)2))).setAdminHash(Matchers.anyString());
        ((ConfigDocument.Config)Mockito.verify((Object)this.configFile, (VerificationMode)Mockito.times((int)101))).getAdminHash();
    }
}

