/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.boot;

import com.cenqua.fisheye.boot.OptsSetter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class OptsSetterTest {
    @Test
    public void shouldSetMaxHeap() throws Exception {
        this.testUpdateOpts(null, null, (Matcher<? super String>)Matchers.allOf((Matcher[])new Matcher[]{Matchers.containsString((String)"-Xmx1024m")}));
    }

    @Test
    public void shouldKeepExistingOptions() throws Exception {
        String fisheyeOpts = "-Xmx2g -XX:MaxPermSize=128m";
        this.testUpdateOpts(fisheyeOpts, null, (Matcher<? super String>)Matchers.allOf((Matcher)Matchers.containsString((String)fisheyeOpts), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"-Xmx1024m")), (Matcher)Matchers.containsString((String)"-XX:MaxPermSize=128m")));
    }

    @Test
    public void shouldHonorNoOverride() throws Exception {
        this.testUpdateOpts(null, "1", (Matcher<? super String>)Matchers.allOf((Matcher)Matchers.not((Matcher)Matchers.containsString((String)"-Xmx1024m")), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"MaxPermSize"))));
    }

    private void testUpdateOpts(String fisheyeOpts, String noOverride, Matcher<? super String> resultMatcher) throws Exception {
        Assert.assertThat((Object)new OptsSetter().updateOpts(fisheyeOpts, noOverride), resultMatcher);
    }
}

