/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.api;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.api.ApiImplementation;
import com.cenqua.fisheye.api.BaseApiHandler;
import com.cenqua.fisheye.api.XmlRpcApiHandler;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import java.io.IOException;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ApiImplementationTest {
    @Mock
    private BaseApiHandler.Context context;
    @Mock
    private RepositoryManager repositoryManager;
    @Mock
    private UserManager um;
    private BaseApiHandler apiHandler;
    private ApiImplementation apiImplementation;
    private List<String> apiErrors;
    private UserLogin user = new UserLogin(new FecruUser("mocksalot"), null, null);
    private RepositoryHandle repo = new RepositoryHandle("repo", null, null, null);

    @Before
    public void setUp() throws Exception {
        this.apiHandler = (BaseApiHandler)Mockito.spy((Object)new XmlRpcApiHandler());
        ((BaseApiHandler)Mockito.doReturn((Object)this.context).when((Object)this.apiHandler)).getContext();
        this.apiHandler.setup(this.context);
        Mockito.when((Object)this.context.getUser()).thenReturn((Object)this.user);
        this.apiImplementation = new ApiImplementation(this.apiHandler, this.repositoryManager, this.um);
    }

    @Test
    public void testNonExistantRepoDoesntLeakInfo() throws Exception {
        this.setupListPathHistoryCommand();
        Mockito.when((Object)this.repositoryManager.getRepository(this.repo.getName())).thenReturn(null);
        this.apiImplementation.handle();
        Assert.assertThat((Object)this.apiHandler.getErrors(), (Matcher)IsCollectionContaining.hasItem((Object)String.format("Repository unavailable: %s", this.repo.getName())));
    }

    @Test
    public void testInaccessibleRepoDoesntLeakInfo() throws Exception {
        this.setupListPathHistoryCommand();
        Mockito.when((Object)this.repositoryManager.getRepository(this.repo.getName())).thenReturn((Object)this.repo);
        Mockito.when((Object)this.um.hasPermissionToAccess((Principal)this.user, this.repo)).thenReturn((Object)false);
        this.apiImplementation.handle();
        Assert.assertThat((Object)this.apiHandler.getErrors(), (Matcher)IsCollectionContaining.hasItem((Object)String.format("Repository unavailable: %s", this.repo.getName())));
    }

    private void setupListPathHistoryCommand() throws IOException {
        ((BaseApiHandler)Mockito.doReturn((Object)"listPathHistory").when((Object)this.apiHandler)).parseCommand();
        ((BaseApiHandler)Mockito.doReturn((Object)this.repo.getName()).when((Object)this.apiHandler)).getStringParam(1, "rep");
        ((BaseApiHandler)Mockito.doNothing().when((Object)this.apiHandler)).sendError(Matchers.anyString());
    }
}

