/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.junit.Test;

public final class RepositoryPropertiesTest {
    @Test
    public void testXPath() throws Exception {
        XmlObject[] xmlObjects;
        ConfigDocument d = this.loadConfigDocument("test-config.xml");
        XmlOptions opts = new XmlOptions();
        opts.setUseDefaultNamespace();
        ArrayList errors = new ArrayList();
        opts.setErrorListener(errors);
        opts.setLoadSubstituteNamespaces(RootConfig.makeExplicitNamespaces());
        String s = "$this//repository";
        for (XmlObject xmlObject : xmlObjects = d.selectPath(s, opts)) {
            System.out.println("xmlObject.getDomNode().getLocalName() = " + xmlObject.getDomNode().getLocalName());
            XmlOptions o = new XmlOptions();
            o.setSaveOuter();
            xmlObject.save((OutputStream)System.out, o);
            System.out.println();
        }
        System.out.println(errors);
    }

    @Test
    public void testSelectPath() throws Exception {
        XmlObject[] xmlObjects;
        ConfigDocument d = this.loadConfigDocument("test-config.xml");
        XmlOptions opts = new XmlOptions();
        opts.setUseDefaultNamespace();
        ArrayList errors = new ArrayList();
        opts.setErrorListener(errors);
        opts.setLoadSubstituteNamespaces(RootConfig.makeExplicitNamespaces());
        for (XmlObject xmlObject : xmlObjects = d.getConfig().selectChildren("http://www.cenqua.com/fisheye/config-1", "repository")) {
            System.out.println("xmlObject.getDomNode().getLocalName() = " + xmlObject.getDomNode().getLocalName());
            XmlOptions o = new XmlOptions();
            o.setSaveOuter();
            xmlObject.save((OutputStream)System.out, o);
            System.out.println();
        }
        System.out.println(errors);
    }

    private ConfigDocument loadConfigDocument(String configName) throws IOException, XmlException {
        RootConfig rc = new RootConfig();
        AppConfig.resetConfig((RootConfig)rc);
        InputStream in = this.getClass().getResourceAsStream(configName);
        return TestFishEyeInstances.loadConfigDocumentFromStream(in);
    }
}

