/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye;

import com.cenqua.fisheye.Path;
import junit.framework.TestCase;

public class PathTest
extends TestCase {
    public void testPaths() {
        PathTest.assertTrue((String)"'' is root", (boolean)new Path((CharSequence)"").isRoot());
        PathTest.assertTrue((String)"'/' is root", (boolean)new Path((CharSequence)"/").isRoot());
        PathTest.assertEquals((Object)new Path((CharSequence)"/"), (Object)new Path((CharSequence)""));
    }

    public void testWindowsPath() {
        Path p = new Path((CharSequence)"hello\\there");
        PathTest.assertEquals((int)1, (int)p.getComponents().length);
        p = new Path((CharSequence)"hello\\there", true);
        PathTest.assertEquals((int)2, (int)p.getComponents().length);
        p = new Path((CharSequence)"\\hello\\there", true);
        PathTest.assertEquals((int)3, (int)p.getComponents().length);
        Path p2 = new Path(p, "foo", true);
        PathTest.assertEquals((int)4, (int)p2.getComponents().length);
        p2 = new Path(p, "foo\\bar", true);
        PathTest.assertEquals((int)5, (int)p2.getComponents().length);
    }

    public void testRelativePath() {
        PathTest.assertEquals((Object)new Path((CharSequence)"1/3"), (Object)new Path((CharSequence)"1/2/../3").simplify());
        PathTest.testRelativePath("3/4/5", "1/2/3/4/5", "1/2/");
        PathTest.testRelativePath("../CoreTypes/selectors.html", "/ant/docs/manual/CoreTypes/selectors.html", "/ant/docs/manual/api/");
        PathTest.testRelativePath("test.txt", "trunk/test.txt", "trunk");
        PathTest.testRelativePath("..", "trunk", "trunk/test.txt");
    }

    private static void testRelativePath(String expected, String path, String prefix) {
        Path relativePath = new Path((CharSequence)path).getRelativePath(new Path((CharSequence)prefix));
        if (expected == null) {
            PathTest.assertNull((Object)relativePath);
        } else {
            PathTest.assertEquals((Object)new Path((CharSequence)expected), (Object)relativePath);
        }
    }

    public void testAbbrev() {
        PathTest.assertAbbrev("the/brown", "the/brown", 5);
        PathTest.assertAbbrev("the/.../brown", "the/quick/brown", 5);
        PathTest.assertAbbrev("the/.../brown", "the/quic1/quic2/brown", 5);
        PathTest.assertAbbrev("the/.../brown", "the/quic1/very/quic2/brown", 5);
        PathTest.assertAbbrev("the/quic1/.../quic2/brown", "the/quic1/very/quic2/brown", 21);
        PathTest.assertAbbrev("longdir/dir1/the/quick/brown/.../blah/foo/bar/file.txt", "longdir/dir1/the/quick/brown/fox/jumps/over/the/lazy/dog/too/many/cooks/spoil/the/broth/blah/foo/bar/file.txt", 50);
    }

    private static void assertAbbrev(String expected, String input, int maxlen) {
        PathTest.assertEquals((String)expected, (String)new Path((CharSequence)input).abbreviate(maxlen).getPath());
    }

    public void testJoin() {
        PathTest.assertEquals((String)"", (String)Path.join((String)"", (String)""));
        PathTest.assertEquals((String)"/", (String)Path.join((String)"/", (String)""));
        PathTest.assertEquals((String)"/", (String)Path.join((String)"", (String)"/"));
        PathTest.assertEquals((String)"/", (String)Path.join((String)"/", (String)"/"));
        PathTest.assertEquals((String)"asd", (String)Path.join((String)"asd", (String)""));
        PathTest.assertEquals((String)"asd/", (String)Path.join((String)"asd", (String)"/"));
        PathTest.assertEquals((String)"asd", (String)Path.join((String)"", (String)"asd"));
        PathTest.assertEquals((String)"/asd", (String)Path.join((String)"/", (String)"asd"));
        PathTest.assertEquals((String)"asd/asd", (String)Path.join((String)"asd", (String)"asd"));
        PathTest.assertEquals((String)"asd/asd", (String)Path.join((String)"asd/", (String)"asd"));
        PathTest.assertEquals((String)"asd/asd", (String)Path.join((String)"asd", (String)"/asd"));
        PathTest.assertEquals((String)"asd/asd", (String)Path.join((String)"asd/", (String)"/asd"));
    }

    public void testAncestor() {
        PathTest.assertTrue((boolean)new Path((CharSequence)"/").isAncestor(new Path((CharSequence)"/blah")));
        PathTest.assertFalse((boolean)new Path((CharSequence)"/blah").isAncestor(new Path((CharSequence)"/blah")));
        PathTest.assertTrue((boolean)new Path((CharSequence)"/blah").isAncestor(new Path((CharSequence)"/blah/blah")));
        PathTest.assertFalse((boolean)new Path((CharSequence)"/").isAncestor(new Path((CharSequence)"/")));
        PathTest.assertFalse((boolean)new Path((CharSequence)"").isAncestor(new Path((CharSequence)"/")));
    }

    public void testExtension() {
        PathTest.assertEquals((String)"txt", (String)new Path((CharSequence)"file.txt").getExtension());
        PathTest.assertEquals((String)"java", (String)new Path((CharSequence)"file.txt.java").getExtension());
        PathTest.assertEquals(null, (String)new Path((CharSequence)"file").getExtension());
        PathTest.assertEquals(null, (String)new Path((CharSequence)"file.").getExtension());
    }
}

