/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.cvsrep.CvsScmConfig;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.cvsrep.RcsFileHistoryFactory;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.InfinityDbUtil;
import com.cenqua.fisheye.io.BufferedRandomAccessInputStream;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetResolver;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonFileRevision;
import com.cenqua.fisheye.search.SearchResults;
import com.cenqua.fisheye.search.query.FishQuery;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.cenqua.fisheye.vis.BranchTable;
import com.cenqua.fisheye.vis.DrawContext;
import com.cenqua.fisheye.vis.DrawContextMetrics;
import com.cenqua.fisheye.vis.Graph;
import com.cenqua.fisheye.vis.HistoryRenderer;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.infinitydb.InfinityDB;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.hamcrest.Matcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class FisheyeTestUtil {
    public static File getTmpDir() {
        File f = new File(FisheyeTestEnv.WORKSPACE_DIR, "output/tmp");
        f.mkdirs();
        return f;
    }

    public static File createTempFile(String prefix, File dir) throws IOException {
        while (prefix.length() < 3) {
            prefix = prefix + "_";
        }
        return File.createTempFile(prefix, null, dir);
    }

    public static File createTempFile(String prefix) throws IOException {
        return FisheyeTestUtil.createTempFile(prefix, FisheyeTestUtil.getTmpDir());
    }

    public static File createTempDir(String prefix) throws IOException {
        File d = FisheyeTestUtil.createTempFile(prefix);
        d.delete();
        d.mkdirs();
        return d;
    }

    public static void deleteDir(File dir) {
        File[] files = dir.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                FisheyeTestUtil.deleteDir(file);
                continue;
            }
            file.delete();
            File[] nowfiles = dir.listFiles();
            for (int j = 0; nowfiles != null && j < nowfiles.length; ++j) {
                if (!nowfiles[j].getName().contains(".nfs")) continue;
                System.out.println("!! when trying to delete, " + file + " found a turn " + nowfiles[j]);
            }
        }
        dir.delete();
    }

    public static void listDir(PrintStream out, File dir) {
        out.println(dir);
        File[] files = dir.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                FisheyeTestUtil.listDir(out, file);
                continue;
            }
            out.println(file + " " + file.length() + "b");
        }
    }

    public static File createTempDB(String prefix) throws IOException {
        File f = FisheyeTestUtil.createTempFile(prefix);
        f.delete();
        InfinityDbUtil.createIfNeccessary((File)f);
        return f;
    }

    public static InfinityDB createTempDBForWrite() throws IOException {
        File f = FisheyeTestUtil.createTempFile("misc");
        f.delete();
        InfinityDbUtil.createIfNeccessary((File)f);
        return InfinityDB.open((String)f.getAbsolutePath(), (boolean)true);
    }

    public static InfinityDbHandle createTempDBHandleForWrite() throws IOException {
        File f = FisheyeTestUtil.createTempFile("misc");
        f.delete();
        InfinityDbUtil.createIfNeccessary((File)f);
        return new InfinityDbHandle(f);
    }

    public static RcsFileHistoryFactory.Result parseTestRcsFile(Path path) throws IOException, RCSParser.ParseException {
        File f = new File(FisheyeTestEnv.WORKSPACE_DIR, path.getPath() + ",v");
        BufferedRandomAccessInputStream in = new BufferedRandomAccessInputStream(f);
        return RcsFileHistoryFactory.createHistory((BufferedRandomAccessInputStream)in, (Charset)CvsScmConfig.DEFAULT_CVS_ENCODING, (Path)path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertByteIdentical(File f1, File f2) throws IOException {
        Assert.assertEquals((long)f1.length(), (long)f2.length());
        BufferedInputStream in1 = null;
        BufferedInputStream in2 = null;
        try {
            int c1;
            in1 = new BufferedInputStream(new FileInputStream(f1));
            in2 = new BufferedInputStream(new FileInputStream(f2));
            do {
                c1 = ((InputStream)in1).read();
                int c2 = ((InputStream)in2).read();
                Assert.assertEquals((int)c1, (int)c2);
            } while (c1 != -1);
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{in1});
            IOHelper.close((Closeable[])new Closeable[]{in2});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{in1});
        IOHelper.close((Closeable[])new Closeable[]{in2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void assertCharIdentical(File f1, Charset cs1, File f2, Charset cs2) throws IOException {
        BufferedReader in1 = null;
        BufferedReader in2 = null;
        try {
            in1 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f1), cs1));
            in2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f2), cs2));
            int off = 0;
            while (true) {
                int c1 = ((Reader)in1).read();
                int c2 = ((Reader)in2).read();
                if (c1 == -1) {
                    Assert.assertEquals((int)c1, (int)c2);
                    break;
                }
                Assert.assertEquals((String)("at offset " + off), (int)c1, (int)c2);
                ++off;
            }
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{in1});
            IOHelper.close((Closeable[])new Closeable[]{in2});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{in1});
        IOHelper.close((Closeable[])new Closeable[]{in2});
    }

    public static FishQuery parseQuery(String query) {
        ArrayList errors = new ArrayList();
        FishQuery fq = FishQuery.parse((String)query, errors);
        for (String s : errors) {
            System.out.println("Error: " + s);
        }
        Assert.assertEquals((String)("Errors in query: " + errors), (int)0, (int)errors.size());
        return fq;
    }

    public static BufferedImage drawHistory(FileHistory history) {
        Graph graph = new Graph(history);
        graph.collate();
        BranchTable branchTable = new BranchTable(graph);
        branchTable.collate();
        DrawContextMetrics metrics = new DrawContextMetrics();
        HistoryRenderer renderer = new HistoryRenderer(history, graph, branchTable, metrics);
        Dimension size = renderer.computeBounds();
        BufferedImage img = new BufferedImage(size.width, size.height, 1);
        Graphics2D g = img.createGraphics();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.addRenderingHints(hints);
        DrawContext ctx = new DrawContext(g, metrics);
        renderer.draw(ctx);
        g.dispose();
        return img;
    }

    public static void assertSearchResults(SearchResults collator, int expectedSize, String query, int[] changeSetIds) throws Exception {
        int size = collator.size();
        SearchResults.RevisionResultsIterator results = collator.iterateRevisions(0);
        HashMap<String, FileRevision> revs = new HashMap<String, FileRevision>();
        while (results.hasNext()) {
            FileRevision rev = results.nextItem();
            revs.put(rev.getChangeSetId(), rev);
        }
        if (expectedSize != -1) {
            Assert.assertEquals((String)("Result size of query '" + query + "' not correct"), (int)expectedSize, (int)size);
        }
        if (size != 0) {
            for (int changeSetId : changeSetIds) {
                Assert.assertTrue((String)("Result of query '" + query + "' does not contain expected revision: " + changeSetId), (boolean)revs.containsKey(Integer.toString(changeSetId)));
            }
        }
    }

    public static ChangeSet mockChangeSet(String rep, String csid, String commitmsg) {
        return FisheyeTestUtil.mockChangeSet(rep, csid, "author1", commitmsg, System.currentTimeMillis(), new String[0]);
    }

    public static ChangeSet mockChangeSet(String rep, String csid, String author, String commitmsg, long timestamp, String ... branches) {
        return FisheyeTestUtil.mockChangeSet(rep, csid, author, commitmsg, timestamp, Collections.emptyList(), Collections.emptyList(), branches);
    }

    public static ChangeSet mockChangeSet(String rep, String csid, String author, String commitmsg, long timestamp, Iterable<? extends FileRevision> revisions, String ... branches) {
        return FisheyeTestUtil.mockChangeSet(rep, csid, author, commitmsg, timestamp, revisions, Collections.emptyList(), branches);
    }

    public static ChangeSet mockChangeSet(String rep, String csid, String author, String commitmsg, long timestamp, Iterable<? extends FileRevision> revisions, Iterable<Integer> reviewIds, String ... branches) {
        ChangeSet cs = (ChangeSet)Mockito.mock(ChangeSet.class);
        Mockito.when((Object)cs.getRepName()).thenReturn((Object)rep);
        Mockito.when((Object)cs.getId()).thenReturn((Object)csid);
        Mockito.when((Object)cs.getCrossRepoId()).thenReturn((Object)(rep + ":" + csid));
        Mockito.when((Object)cs.getAuthor()).thenReturn((Object)author);
        Mockito.when((Object)cs.getComment()).thenReturn((Object)commitmsg);
        Mockito.when((Object)cs.getDate()).thenReturn((Object)timestamp);
        Mockito.when((Object)cs.getDateValue()).thenReturn((Object)new Date(timestamp));
        Mockito.when((Object)cs.getPaths()).thenReturn(Collections.emptyList());
        Mockito.when((Object)cs.getBranches()).thenReturn((Object)(branches != null ? ImmutableSet.copyOf((Object[])branches) : Collections.emptySet()));
        Mockito.when((Object)cs.getBranch()).thenReturn(branches != null && branches.length > 0 ? branches[0] : null);
        Mockito.when((Object)cs.isInBranch((String)Matchers.argThat((Matcher)org.hamcrest.Matchers.isIn((Object[])branches)))).thenReturn((Object)true);
        Mockito.when((Object)cs.getRevisionsIterable()).thenReturn((Object)ImmutableList.copyOf(revisions));
        Mockito.when((Object)cs.getReviewIds()).thenReturn((Object)ImmutableSet.copyOf(reviewIds));
        Mockito.when((Object)cs.getRevisionInfosCount()).thenReturn((Object)Iterables.size(revisions));
        return cs;
    }

    public static FileRevision mockRevision(String revision, String path) {
        CommonFileRevision rev = (CommonFileRevision)Mockito.mock(CommonFileRevision.class);
        Path pathObj = new Path((CharSequence)path);
        Mockito.when((Object)rev.getPath()).thenReturn((Object)pathObj);
        Mockito.when((Object)rev.getDiffRevision()).thenReturn((Object)new RevInfoKey(pathObj, "before:" + revision));
        Mockito.when((Object)rev.getRevision()).thenReturn((Object)revision);
        Mockito.when((Object)rev.getRevInfoKey()).thenReturn((Object)new RevInfoKey(pathObj, revision));
        return rev;
    }

    public static RepositoryEngine mockEngine(String name) {
        RepositoryEngine engine = (RepositoryEngine)Mockito.mock(RepositoryEngine.class);
        Mockito.when((Object)engine.getName()).thenReturn((Object)name);
        return engine;
    }

    public static RepoHandleMockBuilder createRepositoryHandleMockBuilder(String repositoryName) {
        return new RepoHandleMockBuilder(repositoryName);
    }

    public static RepositoryHandle mockRepoHandle(String name) throws RepositoryHandle.StateException {
        return FisheyeTestUtil.createRepositoryHandleMockBuilder(name).build();
    }

    public static RepositoryHandle mockRepoHandle(String name, ScmType scmType) throws RepositoryHandle.StateException {
        return FisheyeTestUtil.createRepositoryHandleMockBuilder(name).setScmType(scmType).build();
    }

    public static RepositoryManager mockRepoManager(RepositoryHandle ... handles) {
        RepositoryManager manager = (RepositoryManager)Mockito.mock(RepositoryManager.class);
        ImmutableMap repos = Maps.uniqueIndex(Arrays.asList(handles), RepositoryHandle::getName);
        Mockito.when((Object)manager.getRepository(Matchers.anyString())).thenAnswer(arg_0 -> FisheyeTestUtil.lambda$mockRepoManager$64((Map)repos, arg_0));
        Mockito.when((Object)manager.getHandleMap()).thenReturn((Object)ImmutableMap.copyOf((Map)repos));
        Mockito.when((Object)manager.getHandles()).thenReturn((Object)ImmutableList.copyOf(repos.values()));
        return manager;
    }

    public static ChangeSetResolver<ChangeSet> mockChangeSetResolver(ChangeSet ... changeSets) {
        ImmutableMap changeSetMap = Maps.uniqueIndex(Arrays.asList(changeSets), (Function)ChangeSet.TO_CSID);
        return ((Map)changeSetMap)::get;
    }

    private static /* synthetic */ Object lambda$mockRepoManager$64(Map repos, InvocationOnMock invocation) throws Throwable {
        return (RepositoryHandle)repos.get(String.valueOf(invocation.getArguments()[0]));
    }

    public static class RepoHandleMockBuilder {
        private final String name;
        private ScmType scmType = ScmType.SVN;
        private boolean running = true;
        private boolean enabled = true;
        private RepositoryEngine repoEngine;

        private RepoHandleMockBuilder(String name) {
            this.name = name;
        }

        public RepoHandleMockBuilder setScmType(ScmType scmType) {
            this.scmType = scmType;
            return this;
        }

        public RepoHandleMockBuilder setRunning(boolean running) {
            this.running = running;
            return this;
        }

        public RepoHandleMockBuilder setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public RepoHandleMockBuilder setRepositoryEngine(RepositoryEngine repoEngine) {
            this.repoEngine = repoEngine;
            return this;
        }

        public RepositoryHandle build() throws RepositoryHandle.StateException {
            if (null == this.repoEngine) {
                this.repoEngine = FisheyeTestUtil.mockEngine(this.name);
            }
            RepositoryHandle handle = (RepositoryHandle)Mockito.mock(RepositoryHandle.class);
            RepositoryConfig config = (RepositoryConfig)Mockito.mock(RepositoryConfig.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            Mockito.when((Object)handle.getName()).thenReturn((Object)this.name);
            Mockito.when((Object)handle.isRunning()).thenReturn((Object)this.running);
            Mockito.when((Object)handle.getCfg()).thenReturn((Object)config);
            Mockito.when((Object)config.isEnabled()).thenReturn((Object)this.enabled);
            Mockito.when((Object)handle.acquireEngine()).thenReturn((Object)this.repoEngine);
            Mockito.when((Object)handle.withEngine((Function)Matchers.any(Function.class))).thenAnswer(invocation -> ((Function)invocation.getArguments()[0]).apply((Object)this.repoEngine));
            Mockito.when((Object)config.getRepositoryType()).thenReturn((Object)this.scmType);
            return handle;
        }
    }
}

