/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye;

import com.cenqua.fisheye.FishEyeSysProps;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class FishEyeSysPropsTest {
    private static final String TEST_PROPERTY = "test.property";

    @Test
    public void testIntProperty() throws Exception {
        System.getProperties().setProperty(TEST_PROPERTY, "5");
        int value = FishEyeSysProps.loadIntProperty((String)TEST_PROPERTY, (int)6);
        junit.framework.Assert.assertEquals((String)"System property was not set correctly", (int)5, (int)value);
        System.getProperties().remove(TEST_PROPERTY);
    }

    @Test
    public void testIntOverflow() throws Exception {
        System.getProperties().setProperty(TEST_PROPERTY, "2147483648");
        int value = FishEyeSysProps.loadIntProperty((String)TEST_PROPERTY, (int)6);
        junit.framework.Assert.assertEquals((String)"System property was not set correctly", (int)6, (int)value);
        System.getProperties().remove(TEST_PROPERTY);
    }

    @Test
    public void testUnsetintProperty() throws Exception {
        System.getProperties().remove(TEST_PROPERTY);
        int value = FishEyeSysProps.loadIntProperty((String)TEST_PROPERTY, (int)6);
        junit.framework.Assert.assertEquals((String)"System property was not set correctly to default", (int)6, (int)value);
    }

    @Test
    public void testBadIntProperty() throws Exception {
        System.getProperties().setProperty(TEST_PROPERTY, "Blah");
        int value = FishEyeSysProps.loadIntProperty((String)TEST_PROPERTY, (int)6);
        junit.framework.Assert.assertEquals((String)"System property was not set correctly to default value on bad input", (int)6, (int)value);
        System.getProperties().remove(TEST_PROPERTY);
    }

    @Test
    public void testIntLimitsProperty() throws Exception {
        System.getProperties().setProperty(TEST_PROPERTY, "8");
        int value = FishEyeSysProps.loadIntProperty((String)TEST_PROPERTY, (int)2, (int)7, (int)6);
        junit.framework.Assert.assertEquals((String)"System property was not set correctly to max value on too large a value", (int)7, (int)value);
        System.getProperties().setProperty(TEST_PROPERTY, "1");
        value = FishEyeSysProps.loadIntProperty((String)TEST_PROPERTY, (int)2, (int)7, (int)6);
        junit.framework.Assert.assertEquals((String)"System property was not set correctly to min value on too small a value", (int)2, (int)value);
        System.getProperties().remove(TEST_PROPERTY);
        System.getProperties().setProperty(TEST_PROPERTY, "7");
        value = FishEyeSysProps.loadIntProperty((String)TEST_PROPERTY, (int)2, (int)7, (int)6);
        junit.framework.Assert.assertEquals((String)"System property was not set correctly on upper bound", (int)7, (int)value);
        System.getProperties().setProperty(TEST_PROPERTY, "2");
        value = FishEyeSysProps.loadIntProperty((String)TEST_PROPERTY, (int)2, (int)7, (int)6);
        junit.framework.Assert.assertEquals((String)"System property was not set correctly on lower bound", (int)2, (int)value);
        System.getProperties().remove(TEST_PROPERTY);
    }

    @Test
    public void testDoubleProperty() throws Exception {
        System.getProperties().setProperty(TEST_PROPERTY, "0.1");
        double value = FishEyeSysProps.loadDoubleProperty((String)TEST_PROPERTY, (double)0.0, (double)1.0, (double)0.2);
        Assert.assertThat((String)"System property was not set correctly", (Object)value, (Matcher)Matchers.closeTo((double)0.1, (double)1.0E-4));
        System.getProperties().remove(TEST_PROPERTY);
        value = FishEyeSysProps.loadDoubleProperty((String)TEST_PROPERTY, (double)0.0, (double)1.0, (double)0.2);
        Assert.assertThat((String)"System property was not set correctly", (Object)value, (Matcher)Matchers.closeTo((double)0.2, (double)1.0E-4));
    }

    @Test
    public void testBooleanProperty() throws Exception {
        System.getProperties().setProperty(TEST_PROPERTY, "true");
        boolean value = FishEyeSysProps.loadBooleanProperty((String)TEST_PROPERTY, (boolean)false);
        junit.framework.Assert.assertEquals((String)"System property was not set correctly", (boolean)true, (boolean)value);
        System.getProperties().remove(TEST_PROPERTY);
        value = FishEyeSysProps.loadBooleanProperty((String)TEST_PROPERTY, (boolean)false);
        junit.framework.Assert.assertEquals((String)"System property was not set correctly", (boolean)false, (boolean)value);
    }

    @Test
    public void testLongProperty() throws Exception {
        long bigLong = 0x80000000L;
        System.getProperties().setProperty(TEST_PROPERTY, Long.toString(0x80000000L));
        long value = FishEyeSysProps.loadLongProperty((String)TEST_PROPERTY, (long)0L, (long)Long.MAX_VALUE, (long)100L);
        junit.framework.Assert.assertEquals((String)"System property was not set correctly", (long)0x80000000L, (long)value);
        System.getProperties().remove(TEST_PROPERTY);
    }

    @Test
    public void testSystemPropsLoaded() throws Exception {
        System.getProperties().remove("fisheye.avatar.ttl.mins");
        FishEyeSysProps.reloadProperties();
        junit.framework.Assert.assertEquals((String)"Avatar TTL not set to default value", (int)60, (int)FishEyeSysProps.AVATAR_TTL_MINUTES);
        System.getProperties().setProperty("fisheye.avatar.ttl.mins", "80");
        FishEyeSysProps.reloadProperties();
        junit.framework.Assert.assertEquals((String)"Avatar TTL not set to property value value", (int)80, (int)FishEyeSysProps.AVATAR_TTL_MINUTES);
    }
}

