/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye;

import com.cenqua.fisheye.ExcludeSubdirPathAcceptor;
import com.cenqua.fisheye.Path;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ExcludeSubdirPathAcceptorTest {
    @Test
    public void testAccept() throws Exception {
        ExcludeSubdirPathAcceptor espa = new ExcludeSubdirPathAcceptor(new String[]{"cache/cache/plugins/osgi-cache/"});
        Assert.assertThat((String)"file outside excluded folder should be accepted", (Object)espa.accept(new Path((CharSequence)"someFile.txt")), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((String)"file outside excluded folder should be accepted", (Object)espa.accept(new Path((CharSequence)"cache/cache/plugins/someFile.txt")), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((String)"file inside excluded folder should be ignored", (Object)espa.accept(new Path((CharSequence)"cache/cache/plugins/osgi-cache/someFile.txt")), (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
    }

    @Test
    public void testAccept2Paths() throws Exception {
        ExcludeSubdirPathAcceptor espa = new ExcludeSubdirPathAcceptor(new String[]{"cache/cache/plugins/osgi-cache/", "cache/cache/globalfe/idx1"});
        Assert.assertThat((String)"file outside excluded folders should be accepted", (Object)espa.accept(new Path((CharSequence)"someFile.txt")), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((String)"file outside excluded folders should be accepted", (Object)espa.accept(new Path((CharSequence)"cache/cache/plugins/someFile.txt")), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        Assert.assertThat((String)"file inside first excluded folder should be ignored", (Object)espa.accept(new Path((CharSequence)"cache/cache/plugins/osgi-cache/someFile.txt")), (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
        Assert.assertThat((String)"file inside second excluded folder should be ignored", (Object)espa.accept(new Path((CharSequence)"cache/cache/globalfe/idx1/anotherFile.txt")), (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
    }
}

