/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.io.LineReader;
import com.cenqua.fisheye.io.ReaderLineReader;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.LogicalPathMatcher;
import com.cenqua.fisheye.rep.impl.CommonFileRevision;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.cenqua.fisheye.web.rdiff.PatchPrinter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.Assert;

public class DiffTestUtils {
    public static void assertDiff(RevisionCache cache, String expected, int expectedSignificantLines, PatchPrinter.PatchOptions opts, String path, String rs1, String rs2) throws IOException, DbException {
        StringWriter resultOut = new StringWriter();
        PatchPrinter p = new PatchPrinter(cache, (Writer)resultOut);
        if (opts != null) {
            p.setOpts(opts);
        }
        p.sendFileDiff(new Path((CharSequence)path), rs1, rs2);
        resultOut.flush();
        DiffTestUtils.doComparison(resultOut, expected, expectedSignificantLines);
    }

    private static void doComparison(StringWriter resultOut, String expected, int expectedSignificantLines) throws IOException {
        ReaderLineReader resultIn = new ReaderLineReader(LineReader.Mode.MODE_MIXED, (Reader)new StringReader(resultOut.toString()));
        FileReader fin = new FileReader(new File(FisheyeTestEnv.WORKSPACE_DIR, expected));
        ReaderLineReader expectedIn = new ReaderLineReader(LineReader.Mode.MODE_MIXED, (Reader)fin);
        int lcount = 0;
        while (true) {
            String expectedLine = DiffTestUtils.nextNonGarbage((LineReader)expectedIn);
            String resultLine = DiffTestUtils.nextNonGarbage((LineReader)resultIn);
            if (resultLine == null && expectedLine == null) break;
            Assert.assertNotNull((String)("null line, other line is: " + expectedLine), (Object)resultLine);
            Assert.assertNotNull((String)("null line, other line is: " + resultLine), (Object)expectedLine);
            ++lcount;
            Assert.assertEquals((String)expectedLine.trim(), (String)resultLine.trim());
        }
        Assert.assertEquals((int)expectedSignificantLines, (int)lcount);
        fin.close();
    }

    private static String nextNonGarbage(LineReader in) throws IOException {
        String line;
        while (null != (line = in.readLine())) {
            if (DiffTestUtils.isGarbage(line)) continue;
            return line;
        }
        return line;
    }

    private static boolean isGarbage(String s) {
        if (s.startsWith("+") || s.startsWith(" ") || s.startsWith("-") || s.startsWith("@")) {
            return false;
        }
        if (s.startsWith("Index:")) {
            return false;
        }
        return !s.startsWith("\\ No");
    }

    public static void checkDiffs(LogicalPathMatcher pathMatcher, RevisionCache cache) throws DbException {
        if (cache.isAuthorLocEnabled()) {
            for (int i = 1; i < 10000; ++i) {
                CommonFileRevision rev = (CommonFileRevision)cache.getFileRevision(i);
                if (rev == null) {
                    return;
                }
                if (pathMatcher.isTag(rev.getPath()) && rev.isAdded()) continue;
                int diffLinesAdded = 0;
                int diffLinesRemoved = 0;
                if (rev.getHunks() != null) {
                    for (Hunk hunk : rev.getHunks()) {
                        diffLinesAdded += hunk.getToCount();
                        diffLinesRemoved += hunk.getFromCount();
                    }
                }
                if (rev.getAncestorLink() != null && rev.getAncestorLink().isBranchPoint()) {
                    Assert.assertEquals((String)("Revision " + i + " " + rev.getRevInfoKey() + " is first on branch, expect diffLinesAdded == rev.getLinesAdded()"), (int)diffLinesAdded, (int)rev.getLinesAdded());
                    Assert.assertEquals((String)("Revision " + i + " " + rev.getRevInfoKey() + " is first on branch, expect diffLinesRemoved == rev.getLinesRemoved()"), (int)diffLinesRemoved, (int)rev.getLinesRemoved());
                    continue;
                }
                if (rev.getAncestors().isEmpty() && rev.getPredecessor() == null) {
                    Assert.assertEquals((String)("Revision " + i + " " + rev.getRevInfoKey() + " is a new file added to a new location: expect diffLinesAdded == rev.getLinesAdded()"), (int)diffLinesAdded, (int)rev.getLinesAdded());
                    Assert.assertEquals((String)("Revision " + i + " " + rev.getRevInfoKey() + " is a new file added to a new location: expect rev.getLineCount() == rev.getLinesAdded()"), (int)rev.getLineCount(), (int)rev.getLinesAdded());
                    Assert.assertEquals((String)("Revision " + i + " " + rev.getRevInfoKey() + " is a new file added to a new location: expect diffLinesRemoved == rev.getLinesRemoved()"), (int)diffLinesRemoved, (int)rev.getLinesRemoved());
                    Assert.assertEquals((String)("Revision " + i + " " + rev.getRevInfoKey() + " is a new file added to a new location: expect 0 == rev.getLinesRemoved()"), (int)0, (int)rev.getLinesRemoved());
                    continue;
                }
                if (!rev.getAncestors().isEmpty() && rev.getPredecessor() == null) {
                    Assert.assertEquals((String)("Revision " + i + " " + rev.getRevInfoKey() + " is an existing file copied to a new location: expect rev.getLinesAdded() == rev.getLineCount()"), (int)rev.getLinesAdded(), (int)rev.getLineCount());
                    Assert.assertEquals((String)("Revision " + i + " " + rev.getRevInfoKey() + " is an existing file copied to a new location: expect rev.getLinesRemoved() == 0"), (int)rev.getLinesRemoved(), (int)0);
                    continue;
                }
                if (rev.getAncestors().isEmpty() && rev.getPredecessor() != null) continue;
                if (rev.getAncestors().contains(rev.getPredecessor())) {
                    FileRevision ancestor = cache.getFileRevision(rev.getPredecessor());
                    Assert.assertEquals((String)("Revision " + i + " " + rev.getRevInfoKey() + " is modification to an existing file, expect diffLinesAdded == rev.getLinesAdded()"), (int)diffLinesAdded, (int)rev.getLinesAdded());
                    Assert.assertEquals((String)("Revision " + i + " " + rev.getRevInfoKey() + " is modification to an existing file, expect diffLinesRemoved == rev.getLinesRemoved()"), (int)diffLinesRemoved, (int)rev.getLinesRemoved());
                    Assert.assertEquals((String)("Revision " + i + " " + rev.getRevInfoKey() + " is modification to an existing file, expect ancestor.getLineCount() + rev.getLinesAdded() - rev.getLinesRemoved() == rev.getLineCount()"), (int)(ancestor.getLineCount() + rev.getLinesAdded() - rev.getLinesRemoved()), (int)rev.getLineCount());
                    continue;
                }
                if (!rev.getAncestors().contains(rev.getPredecessor())) continue;
                Assert.fail((String)"Unexpected situation");
            }
        }
    }
}

