/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.dbutils.comparison;

import com.atlassian.fisheye.db.DbUtil;
import com.cenqua.dbutils.comparison.ValueNormaliser;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;

public class OracleValueNormaliser
implements ValueNormaliser {
    @Override
    public Object convert(ResultSet rs, int col) throws Exception {
        ResultSetMetaData metadata = rs.getMetaData();
        switch (metadata.getColumnType(col)) {
            case -1: 
            case 12: 
            case 2005: {
                return rs.getString(col);
            }
            case 2: {
                int scale = metadata.getScale(col);
                int precision = metadata.getPrecision(col);
                if (scale == 0) {
                    switch (precision) {
                        case 1: {
                            return DbUtil.maybeNull((ResultSet)rs, (Object)rs.getBoolean(col));
                        }
                        case 10: {
                            return DbUtil.maybeNull((ResultSet)rs, (Object)rs.getInt(col));
                        }
                        case 19: {
                            return DbUtil.maybeNull((ResultSet)rs, (Object)rs.getLong(col));
                        }
                    }
                }
                throw new UnsupportedOperationException(String.format("Unable to convert Oracle numeric with unexpected scale, precision: %d, %d", scale, precision));
            }
        }
        throw new UnsupportedOperationException(String.format("Unable to convert unexpected type %d for column %s", metadata.getColumnType(col), metadata.getColumnName(col)));
    }
}

