/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.dbutils.comparison;

import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.dbutils.comparison.DbComparator;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DbComparatorTest {
    private static final Logger LOGGER = Logger.getLogger(DbComparatorTest.class);
    private Connection c1;
    private Connection c2;
    private File dbdir;
    private DbComparator dbCompare;

    @Before
    public void setUp() throws Exception {
        this.dbdir = new File("./testdb");
        if (this.dbdir.exists()) {
            this.rmdir(this.dbdir);
        }
        this.dbdir.mkdir();
        Properties cfg = new Properties();
        cfg.setProperty("jdbcDriverClass", "org.hsqldb.jdbcDriver");
        cfg.setProperty("jdbcUsername", "sa");
        cfg.setProperty("jdbcPassword", "");
        cfg.setProperty("jdbcUrl", "jdbc:hsqldb:file:" + this.dbdir.getAbsolutePath() + "/db1");
        this.c1 = DbComparatorTest.getConnection(cfg);
        cfg.setProperty("jdbcUrl", "jdbc:hsqldb:file:" + this.dbdir.getAbsolutePath() + "/db2");
        this.c2 = DbComparatorTest.getConnection(cfg);
        this.c1.setAutoCommit(true);
        this.c2.setAutoCommit(true);
        this.dbCompare = new DbComparator(DBType.HSQL, this.c1, DBType.HSQL, this.c2, false);
    }

    @After
    public void tearDown() throws Exception {
        DbComparatorTest.closeHSQLDB(this.c1);
        DbComparatorTest.closeHSQLDB(this.c2);
    }

    private static void closeHSQLDB(Connection conn) throws SQLException {
        if (conn != null && !conn.isClosed()) {
            conn.createStatement().executeUpdate("SHUTDOWN");
            conn.close();
        }
    }

    private void rmdir(File dir) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                this.rmdir(file);
                continue;
            }
            file.delete();
        }
        dir.delete();
    }

    public static Connection getConnection(Properties cfg) throws ClassNotFoundException, SQLException {
        Class.forName(cfg.getProperty("jdbcDriverClass"));
        return DriverManager.getConnection(cfg.getProperty("jdbcUrl"), cfg.getProperty("jdbcUsername"), cfg.getProperty("jdbcPassword"));
    }

    @Test
    public void testCruOnlyWithSameCruTables() throws Exception {
        this.dbCompare = new DbComparator(DBType.HSQL, this.c1, DBType.HSQL, this.c2, true);
        this.c1.createStatement().executeUpdate("create table cru_table1 (foo integer not null);");
        this.c2.createStatement().executeUpdate("create table cru_table1 (foo integer not null);");
        Assert.assertTrue((boolean)this.dbCompare.areEqual());
    }

    @Test
    public void testCruOnlyWithDifferentCruTables() throws Exception {
        this.dbCompare = new DbComparator(DBType.HSQL, this.c1, DBType.HSQL, this.c2, true);
        this.c1.createStatement().executeUpdate("create table cru_table1 (foo integer not null);");
        this.c2.createStatement().executeUpdate("create table cru_table1 (bar integer not null);");
        Assert.assertFalse((boolean)this.dbCompare.areEqual());
    }

    @Test
    public void testCruOnlyWithSameNonCruTables() throws Exception {
        this.dbCompare = new DbComparator(DBType.HSQL, this.c1, DBType.HSQL, this.c2, true);
        this.c1.createStatement().executeUpdate("create table table1 (foo integer not null);");
        this.c2.createStatement().executeUpdate("create table table1 (foo integer not null);");
        Assert.assertTrue((boolean)this.dbCompare.areEqual());
    }

    @Test
    public void testCruOnlyWithDifferentNonCruTables() throws Exception {
        this.dbCompare = new DbComparator(DBType.HSQL, this.c1, DBType.HSQL, this.c2, true);
        this.c1.createStatement().executeUpdate("create table table1 (foo integer not null);");
        this.c2.createStatement().executeUpdate("create table table1 (bar integer not null);");
        Assert.assertTrue((boolean)this.dbCompare.areEqual());
    }

    @Test
    public void testSameTable() throws Exception {
        LOGGER.info((Object)"TEST - database 1 table the same");
        this.c1.createStatement().executeUpdate("create table table1 (ID integer not null, time_stamp timestamp, reviewId integer, newState varchar(255), primary key (ID));");
        this.c2.createStatement().executeUpdate("create table table1 (ID integer not null, time_stamp timestamp, reviewId integer, newState varchar(255), primary key (ID));");
        Assert.assertTrue((boolean)this.dbCompare.areEqual());
    }

    @Test
    public void testExtraTable() throws Exception {
        LOGGER.info((Object)"TEST - extra table");
        this.c1.createStatement().executeUpdate("create table table1 (ID integer not null, time_stamp timestamp, reviewId integer, newState varchar(255), primary key (ID));");
        this.c2.createStatement().executeUpdate("create table table1 (ID integer not null, time_stamp timestamp, reviewId integer, newState varchar(255), primary key (ID));");
        this.c1.createStatement().executeUpdate("create table table2 (ID integer not null, time_stamp timestamp, reviewId integer, primary key (ID));");
        Assert.assertFalse((boolean)this.dbCompare.areEqual());
    }

    @Test
    public void testMissingColumn() throws Exception {
        LOGGER.info((Object)"TEST - missing column");
        this.c2.createStatement().executeUpdate("create table table1 (ID integer not null, time_stamp timestamp, reviewId integer, newState varchar(255), primary key (ID));");
        this.c1.createStatement().executeUpdate("create table table1 (ID integer not null, time_stamp timestamp, reviewId integer, primary key (ID));");
        Assert.assertFalse((boolean)this.dbCompare.areEqual());
    }

    @Test
    public void testExtraColumn() throws Exception {
        LOGGER.info((Object)"TEST - extra column");
        this.c2.createStatement().executeUpdate("create table table1 (ID integer not null, time_stamp timestamp, reviewId integer, newState varchar(255), primary key (ID));");
        this.c1.createStatement().executeUpdate("create table table1 (ID integer not null, time_stamp timestamp, reviewId integer, newState varchar(255), oldState varchar(255), primary key (ID));");
        Assert.assertFalse((boolean)this.dbCompare.areEqual());
    }

    @Test
    public void testExtraNullConstraint() throws Exception {
        LOGGER.info((Object)"TEST - extra not null constraint");
        this.c2.createStatement().executeUpdate("create table table1 (ID integer not null, time_stamp timestamp, reviewId integer, newState varchar(255), primary key (ID));");
        this.c1.createStatement().executeUpdate("create table table1 (ID integer not null, time_stamp timestamp, reviewId integer not null, newState varchar(255), primary key (ID));");
        Assert.assertFalse((boolean)this.dbCompare.areEqual());
    }

    @Test
    public void testChangedType() throws Exception {
        LOGGER.info((Object)"TEST - changed type on timestamp");
        this.c2.createStatement().executeUpdate("create table table1 (ID integer not null, time_stamp timestamp, reviewId integer, newState varchar(255), primary key (ID));");
        this.c1.createStatement().executeUpdate("create table table1 (ID integer not null, time_stamp integer, reviewId integer, newState varchar(255), primary key (ID));");
        Assert.assertFalse((boolean)this.dbCompare.areEqual());
    }

    @Test
    public void testDifferentPK() throws Exception {
        LOGGER.info((Object)"TEST - different primary key (note primary key is automatically not null)");
        this.c2.createStatement().executeUpdate("create table table1 (ID integer not null, time_stamp timestamp, reviewId integer, newState varchar(255), primary key (ID));");
        this.c1.createStatement().executeUpdate("create table table1 (ID integer not null, time_stamp timestamp, reviewId integer, newState varchar(255), primary key (reviewId));");
        Assert.assertFalse((boolean)this.dbCompare.areEqual());
    }

    @Test
    public void testDifferentUC() throws Exception {
        LOGGER.info((Object)"TEST - different unique constraint");
        this.c1.createStatement().executeUpdate("create table table1 (ID integer not null, payload integer, primary key (ID));");
        this.c2.createStatement().executeUpdate("create table table1 (ID integer not null, payload integer, CONSTRAINT constraint2 UNIQUE(payload), primary key (ID));");
        Assert.assertFalse((boolean)this.dbCompare.areEqual());
    }

    @Test
    public void testSameFK() throws Exception {
        LOGGER.info((Object)"TEST - same foreign key");
        this.c1.createStatement().executeUpdate("create table table1 (ID integer not null, myFKID integer, primary key (ID));");
        this.c1.createStatement().executeUpdate("create table table2 (ID integer not null, payload integer, CONSTRAINT constraint2 UNIQUE(payload), primary key (ID));");
        this.c1.createStatement().executeUpdate("alter table table1 ADD CONSTRAINT constraint1 FOREIGN KEY(myFKID) REFERENCES table2(ID)");
        this.c2.createStatement().executeUpdate("create table table1 (ID integer not null, myFKID integer, primary key (ID));");
        this.c2.createStatement().executeUpdate("create table table2 (ID integer not null, payload integer, CONSTRAINT constraint2 UNIQUE(payload), primary key (ID));");
        this.c2.createStatement().executeUpdate("alter table table1 ADD CONSTRAINT constraint1 FOREIGN KEY(myFKID) REFERENCES table2(ID)");
        Assert.assertTrue((boolean)this.dbCompare.areEqual());
    }

    @Test
    public void testLostFK() throws Exception {
        LOGGER.info((Object)"TEST - lost foreign key");
        this.c1.createStatement().executeUpdate("create table table1 (ID integer not null, myFKID integer, primary key (ID));");
        this.c1.createStatement().executeUpdate("create table table2 (ID integer not null, payload integer, CONSTRAINT constraint2 UNIQUE(payload), primary key (ID));");
        this.c2.createStatement().executeUpdate("create table table1 (ID integer not null, myFKID integer, primary key (ID));");
        this.c2.createStatement().executeUpdate("create table table2 (ID integer not null, payload integer, CONSTRAINT constraint2 UNIQUE(payload), primary key (ID));");
        this.c2.createStatement().executeUpdate("alter table table1 ADD CONSTRAINT constraint1 FOREIGN KEY(myFKID) REFERENCES table2(ID)");
        Assert.assertFalse((boolean)this.dbCompare.areEqual());
    }

    @Test
    public void testDiffFK() throws Exception {
        LOGGER.info((Object)"TEST - different foreign key");
        this.c1.createStatement().executeUpdate("create table table1 (ID integer not null, myFKID integer, primary key (ID));");
        this.c1.createStatement().executeUpdate("create table table2 (ID integer not null, payload integer, CONSTRAINT constraint2 UNIQUE(payload), primary key (ID));");
        this.c1.createStatement().executeUpdate("alter table table1 ADD CONSTRAINT constraint1 FOREIGN KEY(myFKID) REFERENCES table2(payload)");
        this.c2.createStatement().executeUpdate("create table table1 (ID integer not null, myFKID integer, primary key (ID));");
        this.c2.createStatement().executeUpdate("create table table2 (ID integer not null, payload integer, CONSTRAINT constraint2 UNIQUE(payload), primary key (ID));");
        this.c2.createStatement().executeUpdate("alter table table1 ADD CONSTRAINT constraint1 FOREIGN KEY(myFKID) REFERENCES table2(ID)");
        Assert.assertFalse((boolean)this.dbCompare.areEqual());
    }

    @Test
    public void testExtraIndex() throws Exception {
        LOGGER.info((Object)"TEST - added index");
        this.c1.createStatement().executeUpdate("create table table1 (ID integer not null, myFKID integer, primary key (ID));");
        this.c2.createStatement().executeUpdate("create table table1 (ID integer not null, myFKID integer, primary key (ID));");
        this.c1.createStatement().executeUpdate("create index FK_IDX ON table1(myFKID)");
        Assert.assertFalse((boolean)this.dbCompare.areEqual());
    }

    @Test
    public void testTwoInxOnColumn() throws Exception {
        LOGGER.info((Object)"TEST - same name index column name");
        this.c1.createStatement().executeUpdate("create table table1 (ID integer not null, myFKID integer, primary key (ID));");
        this.c2.createStatement().executeUpdate("create table table1 (ID integer not null, myFKID integer, primary key (ID));");
        this.c1.createStatement().executeUpdate("create index FK_IDX ON table1(myFKID)");
        this.c2.createStatement().executeUpdate("create index FK_IDX ON table1(myFKID)");
        this.c1.createStatement().executeUpdate("create table table2 (ID integer not null, payload integer, CONSTRAINT constraint2 UNIQUE(payload), primary key (ID));");
        this.c2.createStatement().executeUpdate("create table table2 (ID integer not null, payload integer, CONSTRAINT constraint2 UNIQUE(payload), primary key (ID));");
        this.c1.createStatement().executeUpdate("alter table table1 ADD CONSTRAINT constraint1 FOREIGN KEY(myFKID) REFERENCES table2(payload)");
        this.c2.createStatement().executeUpdate("alter table table1 ADD CONSTRAINT constraint1 FOREIGN KEY(myFKID) REFERENCES table2(payload)");
        Assert.assertTrue((boolean)this.dbCompare.areEqual());
    }

    @Test
    public void testOrdinalPosition() throws Exception {
        LOGGER.info((Object)"TEST - ordinal position");
        this.c1.createStatement().executeUpdate("create table table1 (ID integer not null, primary key (ID));");
        this.c2.createStatement().executeUpdate("create table table1 (ID integer not null, primary key (ID));");
        this.c1.createStatement().executeUpdate("alter table table1 ADD column col2 integer");
        this.c1.createStatement().executeUpdate("alter table table1 ADD column col3 integer");
        this.c2.createStatement().executeUpdate("alter table table1 ADD column col3 integer");
        this.c2.createStatement().executeUpdate("alter table table1 ADD column col2 integer");
        Assert.assertFalse((boolean)this.dbCompare.areEqual());
    }

    @Test
    public void testNoOrdinalPosition() throws Exception {
        LOGGER.info((Object)"TEST - ordinal position");
        this.c1.createStatement().executeUpdate("create table table1 (ID integer not null, primary key (ID));");
        this.c2.createStatement().executeUpdate("create table table1 (ID integer not null, primary key (ID));");
        this.c1.createStatement().executeUpdate("alter table table1 ADD column col2 integer");
        this.c1.createStatement().executeUpdate("alter table table1 ADD column col3 integer");
        this.c2.createStatement().executeUpdate("alter table table1 ADD column col3 integer");
        this.c2.createStatement().executeUpdate("alter table table1 ADD column col2 integer");
        Assert.assertTrue((boolean)this.dbCompare.areEqual(true));
    }
}

