/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.dbutils.comparison;

import com.atlassian.crucible.migration.item.SQLBackup;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.dbutils.ColumnData;
import com.cenqua.dbutils.IndexData;
import com.cenqua.dbutils.RSRowData;
import com.cenqua.dbutils.comparison.IndexPredicateSelector;
import com.cenqua.dbutils.comparison.StringCompareSet;
import com.cenqua.dbutils.comparison.ValueNormaliser;
import com.cenqua.dbutils.comparison.ValueNormaliserSelector;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DbComparator {
    private static final Logger LOGGER = Logger.getLogger(DbComparator.class);
    private static final String[] METADATA_TABLE_TYPES = new String[]{"TABLE"};
    private static final String METADATA_TABLE_NAME_COL = "TABLE_NAME";
    private static final String METADATA_COLUMN_NAME_COL = "COLUMN_NAME";
    private static final StringCompareSet IGNORE_COLUMNS = new StringCompareSet(new String[]{"PK_NAME", "INDEX_NAME", "TABLE_CAT", "PKTABLE_CAT", "FKTABLE_CAT", "TABLE_SCHEM", "FKTABLE_SCHEM", "PKTABLE_SCHEM"});
    private final Connection db1;
    private final DBType db1Type;
    private final boolean cruTablesOnly;
    private final Connection db2;
    private final DBType db2Type;
    private final ValueNormaliser db1ValueNormaliser;
    private final ValueNormaliser db2ValueNormaliser;

    public DbComparator(DBType db1Type, Connection db1, DBType db2Type, Connection db2, boolean tablesPrefixedWithCru) {
        this.db1 = db1;
        this.db1Type = db1Type;
        this.cruTablesOnly = tablesPrefixedWithCru;
        this.db1ValueNormaliser = (ValueNormaliser)db1Type.accept((DBType.Visitor)new ValueNormaliserSelector());
        this.db2 = db2;
        this.db2Type = db2Type;
        this.db2ValueNormaliser = (ValueNormaliser)db2Type.accept((DBType.Visitor)new ValueNormaliserSelector());
    }

    public boolean areEqual() throws Exception {
        return this.areEqual(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contentEqual() throws Exception {
        if (this.db1 == null || this.db2 == null) {
            LOGGER.info((Object)("Connection error: db1=" + this.db1 + ", db2=" + this.db2));
            return false;
        }
        Map<String, String[]> tableMap = this.makeTableMap();
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        for (Map.Entry<String, String[]> tableName : tableMap.entrySet()) {
            ArrayList<String> cols1 = new ArrayList<String>();
            ArrayList<String> cols2 = new ArrayList<String>();
            String db1TableName = tableName.getValue()[0];
            String db2TableName = tableName.getValue()[1];
            try {
                rs1 = this.db1.getMetaData().getColumns(null, null, db1TableName, "%");
                this.collectColumnNames(rs1, cols1);
                rs2 = this.db2.getMetaData().getColumns(null, null, db2TableName, "%");
                this.collectColumnNames(rs2, cols2);
                if (cols1.size() != cols2.size()) {
                    LOGGER.info((Object)(tableName + " column counts differ"));
                    boolean bl = false;
                    return bl;
                }
                if (!cols1.containsAll(cols2)) {
                    LOGGER.info((Object)(tableName + " columns differ"));
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                rs1.close();
                rs2.close();
            }
            String pk1 = this.findPrimaryKey(this.db1, cols1, db1TableName);
            String pk2 = this.findPrimaryKey(this.db2, cols2, db2TableName);
            Statement s1 = this.db1.createStatement();
            Statement s2 = this.db2.createStatement();
            try {
                boolean bl;
                rs1 = s1.executeQuery("select * from " + db1TableName + (pk1.length() == 0 ? "" : " order by " + pk1));
                rs2 = s2.executeQuery("select * from " + db2TableName + (pk2.length() == 0 ? "" : " order by " + pk2));
                while (rs1.next()) {
                    if (rs2.next()) {
                        for (int i = 0; i < cols1.size(); ++i) {
                            Object obj2;
                            String col = (String)cols1.get(i);
                            Object obj1 = this.db1ValueNormaliser.convert(rs1, i + 1);
                            if (this.areEquivalent(obj1, obj2 = this.db2ValueNormaliser.convert(rs2, cols2.indexOf(col) + 1))) continue;
                            LOGGER.info((Object)this.rowToString(tableName.getKey() + " : " + col + " results aren't equal ", rs1, rs2, cols1, cols2));
                            boolean bl2 = false;
                            return bl2;
                        }
                        continue;
                    }
                    LOGGER.info((Object)(tableName.getKey() + " DB2 has fewer rows than DB1"));
                    bl = false;
                    return bl;
                }
                if (!rs2.next()) continue;
                LOGGER.info((Object)(tableName.getKey() + " DB2 has more rows than DB1"));
                bl = false;
                return bl;
            }
            finally {
                s1.close();
                s2.close();
                rs1.close();
                rs2.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findPrimaryKey(Connection db, List<String> cols, String tableName) throws SQLException {
        String pk = "";
        LinkedList<String> colNames = new LinkedList<String>();
        try (ResultSet rs1 = null;){
            rs1 = db.getMetaData().getPrimaryKeys(null, null, tableName);
            while (rs1.next()) {
                colNames.add(rs1.getString(METADATA_COLUMN_NAME_COL));
            }
            Collections.sort(colNames);
            Iterator colNamesIter = colNames.iterator();
            while (colNamesIter.hasNext()) {
                String colName = (String)colNamesIter.next();
                pk = pk + colName;
                if (!colNamesIter.hasNext()) continue;
                pk = pk + ", ";
            }
            if (pk.length() == 0) {
                pk = cols.get(0);
            }
        }
        return pk;
    }

    private static void beforeFirst(ResultSet rs) throws SQLException {
        if (rs.getType() != 1003) {
            rs.beforeFirst();
        }
    }

    private boolean areEquivalent(Object db1Obj, Object db2Obj) {
        if (this.db1Type == DBType.ORACLE && db1Obj == null && this.db2Type != DBType.ORACLE && db2Obj instanceof String && ((String)db2Obj).length() == 0) {
            return true;
        }
        if (this.db2Type == DBType.ORACLE && db2Obj == null && this.db1Type != DBType.ORACLE && db1Obj instanceof String && ((String)db1Obj).length() == 0) {
            return true;
        }
        return ObjectUtils.equals((Object)db1Obj, (Object)db2Obj);
    }

    private void collectColumnNames(ResultSet rs1, List<String> cols1) throws SQLException {
        DbComparator.beforeFirst(rs1);
        while (rs1.next()) {
            cols1.add(rs1.getString(METADATA_COLUMN_NAME_COL).toLowerCase(Locale.US));
        }
    }

    private Map<String, String[]> makeTableMap() throws Exception {
        String lowerTableName;
        String table;
        HashMap<String, String[]> tableMap = new HashMap<String, String[]>();
        ResultSet rs = this.db1.getMetaData().getTables(null, null, "%", METADATA_TABLE_TYPES);
        while (rs.next()) {
            table = rs.getString(METADATA_TABLE_NAME_COL);
            lowerTableName = table.toLowerCase(Locale.US);
            if (!DbComparator.includeTable(this.cruTablesOnly, lowerTableName)) continue;
            tableMap.put(lowerTableName, new String[]{table, null});
        }
        rs.close();
        rs = this.db2.getMetaData().getTables(null, null, "%", METADATA_TABLE_TYPES);
        while (rs.next()) {
            table = rs.getString(METADATA_TABLE_NAME_COL);
            lowerTableName = table.toLowerCase(Locale.US);
            if (!DbComparator.includeTable(this.cruTablesOnly, lowerTableName)) continue;
            tableMap.get((Object)table.toLowerCase((Locale)Locale.US))[1] = table;
        }
        rs.close();
        return tableMap;
    }

    private static boolean includeTable(boolean cruTablesOnly, String tableName) {
        return !cruTablesOnly || SQLBackup.HAS_FECRU_TABLE_PREFIX.test(tableName);
    }

    private String rowToString(String init, ResultSet rs1, ResultSet rs2, List<String> cols1, List<String> cols2) throws Exception {
        StringBuilder results = new StringBuilder(init);
        for (int i = 0; i < cols1.size(); ++i) {
            String col = cols1.get(i);
            Object o1 = this.db1ValueNormaliser.convert(rs1, i + 1);
            Object o2 = this.db2ValueNormaliser.convert(rs2, cols2.indexOf(col) + 1);
            results.append("\n");
            if (!ObjectUtils.equals((Object)o1, (Object)o2)) {
                results.append("[NOT EQ] ");
                if (o1 instanceof String && o2 instanceof String) {
                    results.append("obj equals: ").append(o1.equals(o2)).append("\n");
                    results.append("str equals: ").append(o1.equals(o2)).append("\n");
                    results.append("str compar: ").append(((String)o1).contentEquals((String)o2)).append("\n");
                    results.append("diff: \"").append(StringUtils.difference((String)((String)o1), (String)((String)o2))).append("\"\n ");
                    results.append("HEX1: \"").append(this.hexDump((String)o1)).append("\"\n ");
                    results.append("HEX2: \"").append(this.hexDump((String)o2)).append("\"\n ");
                }
            }
            results.append(col).append(" 1: ").append("[").append(o1 == null ? "null" : o1.getClass().getName()).append("] ").append(o1).append("\n");
            results.append(col).append(" 2: ").append("[").append(o2 == null ? "null" : o2.getClass().getName()).append("] ").append(o2).append("\n");
        }
        return results.toString();
    }

    private String hexDump(String s) {
        StringBuilder result = new StringBuilder();
        for (byte b : s.getBytes()) {
            result.append(Integer.toHexString(b));
        }
        return result.toString();
    }

    public boolean areEqual(boolean ignorePosition) throws Exception {
        if (this.db1 == null || this.db2 == null) {
            LOGGER.info((Object)("Connection error: db1=" + this.db1 + ", db2=" + this.db2));
            return false;
        }
        Set<String> tables = this.compareTableNames();
        if (tables == null) {
            LOGGER.info((Object)"Tables differ");
            return false;
        }
        boolean same = true;
        for (String tableName : tables) {
            if (this.compareTable(tableName, ignorePosition)) continue;
            same = false;
        }
        return same;
    }

    private Set<String> compareTableNames() throws SQLException {
        Set<String> db2Tables;
        Set<String> db1Tables = DbComparator.getTables(this.db1, this.cruTablesOnly);
        if (db1Tables.containsAll(db2Tables = DbComparator.getTables(this.db2, this.cruTablesOnly)) && db2Tables.containsAll(db1Tables)) {
            return db1Tables;
        }
        for (String s : db1Tables) {
            if (db2Tables.contains(s)) {
                db2Tables.remove(s);
                continue;
            }
            LOGGER.info((Object)("db1 has an extra table called " + s));
        }
        for (String s : db2Tables) {
            LOGGER.info((Object)("db1 is missing table " + s));
        }
        return null;
    }

    public static Set<String> getTables(Connection db, boolean cruTablesOnly) throws SQLException {
        HashSet<String> tables = new HashSet<String>();
        ResultSet db1Tables = db.getMetaData().getTables(null, null, "%", METADATA_TABLE_TYPES);
        DbComparator.beforeFirst(db1Tables);
        while (db1Tables.next()) {
            String tableName = db1Tables.getString(METADATA_TABLE_NAME_COL);
            if (!DbComparator.includeTable(cruTablesOnly, tableName)) continue;
            tables.add(tableName);
        }
        return tables;
    }

    private boolean compareTable(String tableName, boolean ignorePos) throws Exception {
        LOGGER.info((Object)("Comparing table " + tableName));
        boolean same = true;
        ResultSet rs1 = this.db1.getMetaData().getColumns(null, null, tableName, "%");
        ResultSet rs2 = this.db2.getMetaData().getColumns(null, null, tableName, "%");
        LOGGER.info((Object)("Comparing column details in table " + tableName));
        if (!DbComparator.compareColumnMetaData(rs1, rs2, tableName, ignorePos)) {
            LOGGER.info((Object)("Columns differ in table " + tableName));
            same = false;
        }
        rs1 = this.db1.getMetaData().getIndexInfo(null, null, tableName, false, false);
        rs2 = this.db2.getMetaData().getIndexInfo(null, null, tableName, false, false);
        LOGGER.info((Object)("Comparing Primary Keys in table " + tableName));
        if (!DbComparator.compareIndexMetaData(rs1, rs2, this.db1Type, this.db2Type, tableName)) {
            LOGGER.info((Object)("Indexes differ in table " + tableName));
            same = false;
        }
        rs1 = this.db1.getMetaData().getPrimaryKeys(null, null, tableName);
        rs2 = this.db2.getMetaData().getPrimaryKeys(null, null, tableName);
        LOGGER.info((Object)("Comparing Primary Keys in table " + tableName));
        if (!DbComparator.compareResultSets(rs1, rs2, tableName, "Primary key in ")) {
            LOGGER.info((Object)("Primary Keys differ in table " + tableName));
            same = false;
        }
        rs1 = this.db1.getMetaData().getExportedKeys(null, null, tableName);
        rs2 = this.db2.getMetaData().getExportedKeys(null, null, tableName);
        LOGGER.info((Object)("Comparing Exported Keys in table " + tableName));
        if (!DbComparator.compareResultSets(rs1, rs2, tableName, "Exported key in ")) {
            LOGGER.info((Object)("Exported Keys differ in table " + tableName));
            same = false;
        }
        rs1 = this.db1.getMetaData().getImportedKeys(null, null, tableName);
        rs2 = this.db2.getMetaData().getImportedKeys(null, null, tableName);
        LOGGER.info((Object)("Comparing Imported Keys in table " + tableName));
        if (!DbComparator.compareResultSets(rs1, rs2, tableName, "Imported Key in ")) {
            LOGGER.info((Object)("Imported Keys differ in table " + tableName));
            same = false;
        }
        return same;
    }

    private static boolean compareResultSetsCommon(ResultSet rs1, ResultSet rs2, String table, String testName) throws SQLException {
        int numCols = rs1.getMetaData().getColumnCount();
        if (numCols != rs2.getMetaData().getColumnCount()) {
            LOGGER.info((Object)(testName + "ResultSet column count differ"));
            return false;
        }
        for (int i = 1; i < numCols; ++i) {
            if (!rs1.getMetaData().getColumnName(i).equals(rs2.getMetaData().getColumnName(i))) {
                LOGGER.info((Object)(testName + "DB1 table " + table + " column name " + rs1.getMetaData().getColumnName(i) + " should be DB2 column name " + rs2.getMetaData().getColumnName(i)));
                return false;
            }
            if (rs1.getMetaData().getColumnType(i) == rs2.getMetaData().getColumnType(i)) continue;
            LOGGER.info((Object)(testName + "DB1 table " + table + " column " + rs1.getMetaData().getColumnName(i) + "column type " + rs1.getMetaData().getColumnType(i) + "should be DB2 column type " + rs2.getMetaData().getColumnType(i)));
            return false;
        }
        return true;
    }

    public static boolean compareIndexMetaData(ResultSet rs1, ResultSet rs2, DBType db1Type, DBType db2Type, String table) throws Exception {
        if (!DbComparator.compareResultSetsCommon(rs1, rs2, table, "Index in ")) {
            return false;
        }
        boolean same = true;
        Set<IndexData> db1Indexes = DbComparator.getIndexes(rs1, db1Type);
        Set<IndexData> db2Indexes = DbComparator.getIndexes(rs2, db2Type);
        for (IndexData indexData : Sets.difference(db1Indexes, (Set)Sets.intersection(db1Indexes, db2Indexes))) {
            LOGGER.info((Object)("Index in DB1 " + indexData + " not in DB2. DB2 indexes:\n" + db2Indexes));
            same = false;
        }
        for (IndexData indexData : Sets.difference(db2Indexes, (Set)Sets.intersection(db1Indexes, db2Indexes))) {
            LOGGER.info((Object)("Index in DB2 " + indexData + " not in DB1. DB1 indexes:\n" + db1Indexes));
            same = false;
        }
        return same;
    }

    private static Set<IndexData> getIndexes(ResultSet rs, DBType dbType) throws Exception {
        Predicate predicate = (Predicate)dbType.accept((DBType.Visitor)new IndexPredicateSelector());
        HashSet<IndexData> dbIndexes = new HashSet<IndexData>();
        while (rs.next()) {
            IndexData indexData = new IndexData(rs);
            if (!predicate.apply((Object)indexData)) continue;
            dbIndexes.add(indexData);
        }
        return dbIndexes;
    }

    public static boolean compareColumnMetaData(ResultSet rs1, ResultSet rs2, String table, boolean ignorePos) throws Exception {
        ColumnData cd;
        if (!DbComparator.compareResultSetsCommon(rs1, rs2, table, "Column in ")) {
            return false;
        }
        boolean same = true;
        HashMap<String, ColumnData> columns = new HashMap<String, ColumnData>();
        while (rs2.next()) {
            cd = new ColumnData(rs2, IGNORE_COLUMNS);
            columns.put(cd.getColumnName(), cd);
        }
        while (rs1.next()) {
            cd = new ColumnData(rs1, IGNORE_COLUMNS);
            if (!columns.containsValue(cd)) {
                ColumnData possibleMatch = (ColumnData)columns.get(cd.getColumnName());
                if (possibleMatch != null) {
                    boolean bl = same = ignorePos && possibleMatch.sameSansPos(cd);
                    if (same) {
                        LOGGER.info((Object)("In table " + table + " Column " + cd.getColumnName() + " are not in the same order. " + possibleMatch.compareReport(cd)));
                        columns.remove(cd.getColumnName());
                        continue;
                    }
                    LOGGER.info((Object)("Column in DB1 " + cd + " doesn't match any DB2 column"));
                    LOGGER.info((Object)possibleMatch.compareReport(cd));
                    continue;
                }
                same = false;
                continue;
            }
            columns.remove(cd.getColumnName());
        }
        for (ColumnData columnData : columns.values()) {
            LOGGER.info((Object)("Column in DB2 " + columnData + " doesn't match any DB1 column"));
            same = false;
        }
        return same;
    }

    public static boolean compareResultSets(ResultSet rs1, ResultSet rs2, String table, String testName) throws Exception {
        RSRowData rowData;
        if (!DbComparator.compareResultSetsCommon(rs1, rs2, table, testName)) {
            return false;
        }
        boolean same = true;
        HashMap<String, RSRowData> rows = new HashMap<String, RSRowData>();
        while (rs2.next()) {
            rowData = new RSRowData(rs2, IGNORE_COLUMNS);
            rows.put(rowData.getColumnName(), rowData);
        }
        while (rs1.next()) {
            rowData = new RSRowData(rs1, IGNORE_COLUMNS);
            if (!rows.containsValue(rowData)) {
                RSRowData possibleMatch = (RSRowData)rows.get(rowData.getColumnName());
                if (possibleMatch != null) {
                    same = possibleMatch.same(rowData);
                    if (same) {
                        LOGGER.info((Object)(testName + table + " Column " + rowData.getColumnName() + " are not exactly the same. " + possibleMatch.compareReport(rowData)));
                        rows.remove(rowData.getColumnName());
                        continue;
                    }
                    LOGGER.info((Object)("Column in DB1 " + rowData + " doesn't match any DB2 column"));
                    LOGGER.info((Object)possibleMatch.compareReport(rowData));
                    continue;
                }
                same = false;
                continue;
            }
            rows.remove(rowData.getColumnName());
        }
        for (RSRowData rowData2 : rows.values()) {
            LOGGER.info((Object)("Column in DB2 " + rowData2 + " doesn't match any DB1 column"));
            same = false;
        }
        return same;
    }
}

