/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.dbutils;

import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.crucible.hibernate.DefaultDBControl;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.DriverSource;
import com.cenqua.fisheye.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class Util {
    private static DefaultDBControl getDBControl(File dbdir, String dbName) {
        File db = new File(dbdir, dbName + "/" + dbName);
        DatabaseConfig dbconfig = new DatabaseConfig(DBType.HSQL, "jdbc:hsqldb:file:" + db.getAbsolutePath(), "sa", "", DriverSource.BUNDLED, 5, 20);
        dbconfig.setParam("hsqldb.log_size", "100");
        return DefaultDBControl.newInstance((DatabaseConfig)dbconfig, (File)new File(AppConfig.getAppHome().getAbsolutePath(), "sql"));
    }

    public static DefaultDBControl createDataBase(int version, File dbdir, String dbName, String initData) throws CruDBException, SQLException {
        File db = new File(dbdir, dbName);
        if (db.exists()) {
            FileUtils.deleteTree((File)db);
        }
        DefaultDBControl dbControl = Util.getDBControl(dbdir, dbName);
        dbControl.createTables(version);
        if (initData != null) {
            dbControl.executeScript(new BufferedReader(new StringReader(initData)));
        }
        dbControl.addConstraints(version);
        dbControl.addInitData(version);
        Util.checkpoint(dbControl);
        return dbControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkpoint(DefaultDBControl dbControl) {
        Connection conn = null;
        Statement s = null;
        try {
            conn = dbControl.getConnection();
            s = conn.createStatement();
            s.execute("CHECKPOINT");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            dbControl.closeConnection(conn);
        }
    }
}

