/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.dbutils;

import com.atlassian.fecru.tx.TxHelperStylePlatformTransactionManager;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

public enum TransactionalContext {
    INSTANCE;

    private ApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{SpringContext.class});

    public <T> T makeItTransactional(T target) {
        String name = target.getClass().getSimpleName();
        Object proxyAfter = this.context.getAutowireCapableBeanFactory().applyBeanPostProcessorsAfterInitialization(target, name);
        return (T)proxyAfter;
    }

    @Configuration
    @EnableTransactionManagement
    public static class SpringContext {
        @Bean
        public PlatformTransactionManager transactionManager() {
            return new TxHelperStylePlatformTransactionManager();
        }
    }
}

