/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.dbutils;

import com.atlassian.crucible.spi.impl.SPIUserUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.review.ParticipantDAO;
import com.atlassian.fecru.review.ParticipantDAOImpl;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.EffectiveUserProviderImpl;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.spi.impl.DefaultTxTemplate;
import com.atlassian.fisheye.spi.impl.DummyTxTemplate;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.cenqua.crucible.hibernate.CruDBException;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.DBControl;
import com.cenqua.crucible.hibernate.DBControlFactory;
import com.cenqua.crucible.hibernate.DBControlFactoryImpl;
import com.cenqua.crucible.hibernate.DBInfo;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.hibernate.HibernateUtilCurrentSessionProvider;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FileRevisionException;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.dao.ContentRootDAO;
import com.cenqua.crucible.model.dao.CrucibleActivityItemDAO;
import com.cenqua.crucible.model.dao.FileRevisionExtraInfoDAO;
import com.cenqua.crucible.model.dao.HibernateContentRootDAO;
import com.cenqua.crucible.model.dao.HibernateCrucibleActivityItemDAO;
import com.cenqua.crucible.model.dao.HibernateFileRevisionExtraInfoDAO;
import com.cenqua.crucible.model.dao.HibernatePermissionSchemeDAO;
import com.cenqua.crucible.model.dao.HibernateProjectDAO;
import com.cenqua.crucible.model.dao.HibernateReviewDAO;
import com.cenqua.crucible.model.dao.HibernateReviewPermaIdDAO;
import com.cenqua.crucible.model.dao.HibernateReviewPropertyDAO;
import com.cenqua.crucible.model.dao.HibernateStateChangeLogDAO;
import com.cenqua.crucible.model.dao.PermissionSchemeDAO;
import com.cenqua.crucible.model.dao.ProjectDAO;
import com.cenqua.crucible.model.dao.ReviewDAO;
import com.cenqua.crucible.model.dao.ReviewPermaIdDAO;
import com.cenqua.crucible.model.dao.ReviewPropertyDAO;
import com.cenqua.crucible.model.dao.StateChangeLogDAO;
import com.cenqua.crucible.model.managers.ActionManager;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.DefaultActionManager;
import com.cenqua.crucible.model.managers.DefaultCommentManager;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.model.managers.LogItemManager;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.model.managers.PermaIdCacheManager;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.ProjectManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.ReviewPropertiesManager;
import com.cenqua.crucible.model.managers.SecureProjectManager;
import com.cenqua.crucible.model.managers.UnreadManager;
import com.cenqua.crucible.model.managers.impl.DefaultPermaIdCacheManager;
import com.cenqua.crucible.model.managers.impl.DefaultPermissionManager;
import com.cenqua.crucible.model.managers.impl.DefaultProjectManager;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import com.cenqua.crucible.model.managers.impl.DefaultReviewPropertiesManager;
import com.cenqua.crucible.revision.FileRevisionInfo;
import com.cenqua.crucible.revision.managers.ContentManager;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.dbutils.TransactionalContext;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.UserManager;
import java.io.File;
import java.util.Date;
import org.apache.log4j.Logger;
import org.mockito.Mockito;
import org.springframework.test.util.ReflectionTestUtils;

public class ModelUtils {
    private static Logger log = Logger.getLogger(ModelUtils.class);
    private File dbdir = FisheyeTestUtil.createTempDir("modelutil");
    private DBControl dbControl;
    private DBControlFactory dbControlFactory = new DBControlFactoryImpl(AppConfig.getInstanceDir(), new File(AppConfig.getInstanceDir(), "sql"));

    public void createBlankDB() throws Exception {
        TestFishEyeInstances.stop();
        DBInfo globalInfo = this.dbControlFactory.getCurrentControl().getInfo();
        if (globalInfo.state() == DBInfo.DBState.STARTED) {
            throw new CruDBException("The global database is already running, state = " + globalInfo.state(), globalInfo.getStartersStacktrace());
        }
        this.destroyDB();
        this.dbdir.mkdir();
        log.info((Object)("Created " + this.dbdir.getAbsolutePath()));
        this.startDB();
    }

    private void startDB() throws CruDBException {
        this.dbControl = TestFishEyeInstances.createTesHSQLController(this.dbdir);
        this.dbControl.start();
    }

    public void destroyDB() throws Exception {
        HibernateUtil.rollbackTransactionIfNotCommitted();
        HibernateUtil.closeSession();
        if (this.dbControl != null) {
            this.dbControl.stop();
            this.dbControl.dropTables();
        }
        AppConfig.getsConfig().closeDB();
        TestFishEyeInstances.deleteData0();
    }

    public static ProjectManager getProjectManager() {
        EffectiveUserProviderImpl effectiveUserProvider = (EffectiveUserProviderImpl)Mockito.mock(EffectiveUserProviderImpl.class);
        UserManager userManager = (UserManager)Mockito.mock(UserManager.class);
        GroupMembershipManager groupMembershipManager = (GroupMembershipManager)Mockito.mock(GroupMembershipManager.class);
        DefaultTxTemplate txTemplate = new DefaultTxTemplate(effectiveUserProvider);
        GlobalPermissionManager globalPermissionManager = (GlobalPermissionManager)Mockito.mock(GlobalPermissionManager.class);
        DefaultPermissionManager permissionManager = new DefaultPermissionManager((PermissionSchemeDAO)new HibernatePermissionSchemeDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider()), (ProjectDAO)new HibernateProjectDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider()), (ReviewDAO)new HibernateReviewDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider()), (CurrentSessionProvider)new HibernateUtilCurrentSessionProvider(), userManager, groupMembershipManager, (EffectiveUserProvider)effectiveUserProvider, globalPermissionManager, (TxTemplate)txTemplate);
        HibernateReviewPermaIdDAO reviewPermaIdDAO = new HibernateReviewPermaIdDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider());
        PermaIdCacheManager permaIdCacheManager = (PermaIdCacheManager)TransactionalContext.INSTANCE.makeItTransactional(new DefaultPermaIdCacheManager((ReviewPermaIdDAO)reviewPermaIdDAO));
        DefaultProjectManager projectManager = new DefaultProjectManager((ProjectDAO)new HibernateProjectDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider()), (ReviewDAO)new HibernateReviewDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider()), (ReviewPermaIdDAO)reviewPermaIdDAO, (ContentRootDAO)new HibernateContentRootDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider()), (EventPublisher)Mockito.mock(EventPublisher.class), permaIdCacheManager);
        projectManager.setPermissionManager((PermissionManager)permissionManager);
        ProjectManager proxy = (ProjectManager)TransactionalContext.INSTANCE.makeItTransactional(projectManager);
        ReflectionTestUtils.setField((Object)projectManager, (String)"self", (Object)proxy);
        return proxy;
    }

    public static PermissionManager getPermissionManager(UserManager userManager, GroupMembershipManager groupMembershipManager, GlobalPermissionManager globalPermissionManager) {
        EffectiveUserProviderImpl effectiveUserProvider = (EffectiveUserProviderImpl)Mockito.mock(EffectiveUserProviderImpl.class);
        DefaultTxTemplate txTemplate = new DefaultTxTemplate(effectiveUserProvider);
        return new DefaultPermissionManager((PermissionSchemeDAO)new HibernatePermissionSchemeDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider()), (ProjectDAO)new HibernateProjectDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider()), (ReviewDAO)new HibernateReviewDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider()), (CurrentSessionProvider)new HibernateUtilCurrentSessionProvider(), userManager, groupMembershipManager, (EffectiveUserProvider)Mockito.mock(EffectiveUserProvider.class), globalPermissionManager, (TxTemplate)txTemplate);
    }

    public static DefaultReviewManager getReviewManagerWithMockedManagersAndRealDAOs() {
        ParticipantDAOImpl participantDAO = new ParticipantDAOImpl((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider());
        HibernateReviewPropertyDAO reviewPropertyDAO = new HibernateReviewPropertyDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider());
        HibernateReviewDAO reviewDAO = new HibernateReviewDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider());
        HibernateStateChangeLogDAO stateChangeLogDAO = new HibernateStateChangeLogDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider());
        HibernateFileRevisionExtraInfoDAO fileRevisionExtraInfoDAO = new HibernateFileRevisionExtraInfoDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider());
        HibernateCrucibleActivityItemDAO crucibleActivityItemDAO = new HibernateCrucibleActivityItemDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider());
        HibernateReviewPermaIdDAO reviewPermaIdDAO = new HibernateReviewPermaIdDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider());
        return new DefaultReviewManager((EventPublisher)Mockito.mock(EventPublisher.class), (ActionManager)new DefaultActionManager(), (SPIUserUtils)Mockito.mock(SPIUserUtils.class), (CommentManager)Mockito.mock(CommentManager.class), (ParticipantDAO)participantDAO, (ReviewPropertyDAO)reviewPropertyDAO, (ReviewDAO)reviewDAO, (StateChangeLogDAO)stateChangeLogDAO, (FileRevisionExtraInfoDAO)fileRevisionExtraInfoDAO, (CrucibleActivityItemDAO)crucibleActivityItemDAO, (ReviewPermaIdDAO)reviewPermaIdDAO, (PatchManager)Mockito.mock(PatchManager.class), (TxTemplate)new DummyTxTemplate());
    }

    public static PermissionManager getPermissionManager() {
        return ModelUtils.getPermissionManager((UserManager)Mockito.mock(UserManager.class), (GroupMembershipManager)Mockito.mock(GroupMembershipManager.class), (GlobalPermissionManager)Mockito.mock(GlobalPermissionManager.class));
    }

    public static TxTemplate getTxTemplate() {
        return new DefaultTxTemplate((EffectiveUserProviderImpl)Mockito.mock(EffectiveUserProviderImpl.class));
    }

    public static CommentManager getCommentManager(SecureProjectManager secureProjectManager, EventPublisher eventPublisher) {
        SPIUserUtils spiUserUtils = (SPIUserUtils)Mockito.mock(SPIUserUtils.class);
        UnreadManager unreadManager = new UnreadManager();
        LogItemManager logItemManager = (LogItemManager)Mockito.mock(LogItemManager.class);
        return new DefaultCommentManager(eventPublisher, spiUserUtils, unreadManager, secureProjectManager, (CurrentSessionProvider)new HibernateUtilCurrentSessionProvider(), logItemManager);
    }

    public static CommentManager getCommentManager(SecureProjectManager secureProjectManager) {
        return ModelUtils.getCommentManager(secureProjectManager, (EventPublisher)Mockito.mock(EventPublisher.class));
    }

    public static CommentManager getCommentManager() {
        return ModelUtils.getCommentManager((SecureProjectManager)Mockito.mock(SecureProjectManager.class), (EventPublisher)Mockito.mock(EventPublisher.class));
    }

    public static ReviewPropertiesManager getReviewPropertiesManager() {
        return new DefaultReviewPropertiesManager((ReviewPropertyDAO)new HibernateReviewPropertyDAO((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider()), ModelUtils.getReviewManager(), (TxTemplate)SpringContext.getComponent((String)"txTemplate"));
    }

    public static Review createBlankTestReview(String name) throws Exception {
        return ModelUtils.createBlankTestReview(name, ModelUtils.getProjectManager().getDefaultProject());
    }

    public static Review createBlankTestReview(String name, Project project) throws Exception {
        return ModelUtils.createBlankTestReview(name, project, Review.ReviewType.REVIEW);
    }

    public static Review createBlankTestReview(String name, Project project, Review.ReviewType type) throws Exception {
        FecruUser user = ModelUtils.makeAndSaveUser(name.replace("'", "") + "user");
        Review r = DefaultReviewManager.get().createReviewWithDefaults(ModelUtils.getProjectManager(), project, name, user);
        r.setCreator(user);
        r.setAuthor(user);
        r.setModerator(user);
        r.setType(type);
        return r;
    }

    public static ReviewManager getReviewManager() {
        return DefaultReviewManager.get();
    }

    public static FecruUser makeAndSaveUser(String name) throws Exception {
        UserManager userManager = (UserManager)SpringContext.getComponent(UserManager.class, (String)"userManager");
        if (userManager.getUser(name) == null) {
            return userManager.addUser(name, name, name, name, true);
        }
        return userManager.getUser(name);
    }

    public static CrucibleRevision createFileRevision(ContentManager contentManager, Source source, String path, String revision) throws FileRevisionException {
        FileRevisionInfo fri = source.getFileRevisionInfo(path, revision);
        fri = new FileRevisionInfo(fri.getPath(), fri.getRevision(), fri.getRevisionDisplayName() + " Test", fri.getDetails());
        return contentManager.makeCrucibleRevision(source.getName(), fri);
    }

    public static CrucibleRevision createCrucibleRevision(String source, String path, String rev, String displayRev, Date date) {
        return FileRevisionManager.createRevision((String)source, (String)path, (String)rev, (String)displayRev, (Date)date);
    }
}

